/*
 * Decompiled with CFR 0.152.
 */
package parser.absconparseur.tools;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import parser.absconparseur.InstanceTokens;
import parser.absconparseur.PredicateTokens;
import parser.absconparseur.Toolkit;
import parser.absconparseur.XMLManager;
import parser.absconparseur.components.PAllDifferent;
import parser.absconparseur.components.PConstraint;
import parser.absconparseur.components.PCumulative;
import parser.absconparseur.components.PDomain;
import parser.absconparseur.components.PElement;
import parser.absconparseur.components.PExtensionConstraint;
import parser.absconparseur.components.PIntensionConstraint;
import parser.absconparseur.components.PPredicate;
import parser.absconparseur.components.PRelation;
import parser.absconparseur.components.PVariable;
import parser.absconparseur.components.PWeightedSum;
import parser.absconparseur.intension.EvaluationManager;
import parser.absconparseur.tools.DocumentModifier;
import parser.absconparseur.tools.InstanceCheckerEngine;
import parser.absconparseur.tools.LexicographicIterator;

public class InstanceCheckerParser {
    private InstanceCheckerEngine engine;
    private String instanceName;
    private String format;
    private String type;
    private Set<String> allNameIdentifiers;
    private Map<String, PDomain> mapOfDomains;
    private Map<String, PVariable> mapOfVariables;
    private Map<String, PRelation> mapOfRelations;
    private Map<String, PPredicate> mapOfPredicates;
    private Map<String, PConstraint> mapOfConstraints;
    private String[] domainNames;
    private String[] variableNames;
    private String[] relationNames;
    private String[] predicateNames;
    private String[] constraintNames;
    private boolean competitionControl = false;
    private List<PRelation> newRelations;
    private Map<String, String> constraintsToNewRelations;
    private int[] weights;
    private boolean b;

    public List<PRelation> getNewRelations() {
        return this.newRelations;
    }

    public String getName() {
        return this.instanceName;
    }

    public Map<String, PRelation> getRelationsMap() {
        return this.mapOfRelations;
    }

    public Map<String, PPredicate> getPredicatesMap() {
        return this.mapOfPredicates;
    }

    public Map<String, String> getConstraintsToNewRelations() {
        return this.constraintsToNewRelations;
    }

    public boolean hasCanonicalNames() {
        int i;
        for (i = 0; i < this.domainNames.length; ++i) {
            if (this.domainNames[i].equals(InstanceTokens.getDomainNameFor(i))) continue;
            return false;
        }
        for (i = 0; i < this.variableNames.length; ++i) {
            if (this.variableNames[i].equals(InstanceTokens.getVariableNameFor(i))) continue;
            return false;
        }
        if (this.relationNames != null) {
            for (i = 0; i < this.relationNames.length; ++i) {
                if (this.relationNames[i].equals(InstanceTokens.getRelationNameFor(i))) continue;
                System.out.println(" the " + i + "th relation is called " + this.relationNames[i]);
                return false;
            }
        }
        if (this.predicateNames != null) {
            for (i = 0; i < this.predicateNames.length; ++i) {
                if (this.predicateNames[i].equals(InstanceTokens.getPredicateNameFor(i))) continue;
                return false;
            }
            for (PPredicate predicate : this.mapOfPredicates.values()) {
                String[] formalParameters = predicate.getFormalParameters();
                for (int i2 = 0; i2 < formalParameters.length; ++i2) {
                    if (formalParameters[i2].equals(InstanceTokens.getParameterNameFor(i2))) continue;
                    return false;
                }
            }
        }
        for (int i3 = 0; i3 < this.constraintNames.length; ++i3) {
            if (this.constraintNames[i3].equals(InstanceTokens.getConstraintNameFor(i3))) continue;
            return false;
        }
        return true;
    }

    private int parseInt(String attribute, String value) throws FormatException {
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            throw new FormatException(attribute + " is not given an integer value (or does not exist)");
        }
    }

    private int parsePositiveInt(String attribute, String value) throws FormatException {
        int v = this.parseInt(attribute, value);
        if (v < 0) {
            throw new FormatException(attribute + " is not strictly positive");
        }
        return v;
    }

    private int parseStrictlyPositiveInt(String attribute, String value) throws FormatException {
        int v = this.parseInt(attribute, value);
        if (v <= 0) {
            throw new FormatException(attribute + " is not strictly positive");
        }
        return v;
    }

    private String nextToken(String constraintName, StringTokenizer st) throws FormatException {
        try {
            return st.nextToken();
        }
        catch (Exception e) {
            throw new FormatException("Ill-formed Parameters of " + constraintName);
        }
    }

    private void checkAndRecord(String identifier, String context) throws FormatException {
        if (identifier.length() == 0) {
            throw new FormatException("Missing name attribute for a " + context + ".");
        }
        for (int i = 0; i < identifier.length(); ++i) {
            char c = identifier.charAt(i);
            if (c == '_' || Character.isLetterOrDigit(c) || c == '-') continue;
            throw new FormatException("Invalid name attribute " + identifier + " for a " + context);
        }
        if (this.allNameIdentifiers.contains(identifier)) {
            throw new FormatException("Invalid name attribute " + identifier + " as it occurs at least twice in the description of the instance");
        }
        this.allNameIdentifiers.add(identifier);
    }

    private void parsePresentation(Element presentationElement) throws FormatException {
        if (presentationElement == null) {
            throw new FormatException("The element presentation is absent.");
        }
        this.instanceName = presentationElement.getAttribute("name");
        if (!this.instanceName.equals("") && !this.instanceName.equals("?")) {
            this.checkAndRecord(this.instanceName, "presentation");
        }
        this.format = presentationElement.getAttribute("format");
        if (!this.format.equals("XCSP 2.0") && !this.format.equals("XCSP 2.1")) {
            throw new FormatException("The value of the attribute format of presentation is not valid as it is different from XCSP 2.0 and XCSP 2.1.");
        }
        this.type = presentationElement.getAttribute("type".trim());
        String string = this.type = this.type.length() == 0 || this.type.equals("?") ? "CSP" : this.type;
        if (!this.type.equals("CSP") && !this.type.equals("WCSP")) {
            throw new FormatException("The value of the attribute type of presentation is not valid as it is different from CSP and WCSP.");
        }
        if (this.type.equals("WCSP") && !this.format.equals("XCSP 2.1")) {
            throw new FormatException("For WCSP, only format XCSP 2.1 is currently accepted.");
        }
        if (this.competitionControl) {
            if (this.instanceName.length() != 0 && !this.instanceName.equals("?")) {
                throw new FormatException("For the 2008 competition, the value of the attribute name of presentation must be absent or set to ?.");
            }
            String max = presentationElement.getAttribute("maxConstraintArity");
            if (max.length() == 0) {
                throw new FormatException("For the 2008 competition, the attribute maxConstraintArity must be present.");
            }
            if (presentationElement.getTextContent().length() != 0) {
                throw new FormatException("For the 2008 competition, the content of the element presentation must be empty.");
            }
            String solution = presentationElement.getAttribute("solution");
            if (solution.length() != 0) {
                throw new FormatException("For the 2008 competition, the attribute solution of presentation must be removed.");
            }
            String nbSolutions = presentationElement.getAttribute("nbSolutions");
            if (nbSolutions.length() != 0) {
                throw new FormatException("For the 2008 competition, the attribute nbSolutions of presentation must be removed.");
            }
        }
    }

    private int[] parseDomainValues(String domainName, int nbValues, String s) throws FormatException {
        int[] values = new int[nbValues];
        StringTokenizer st = new StringTokenizer(s);
        int cnt = 0;
        while (st.hasMoreTokens() && cnt < values.length) {
            String token = st.nextToken();
            int position = token.indexOf("..");
            if (position == -1) {
                values[cnt++] = this.parseInt("pb with value " + token + " in domain " + domainName, token);
                continue;
            }
            int min = this.parseInt("pb with min value of interval " + token + " in domain " + domainName, token.substring(0, position));
            int max = this.parseInt("pb with max value of interval " + token + " in domain " + domainName, token.substring(position + "..".length()));
            if (max < min) {
                throw new FormatException("pb with interval (max > min) " + token + " in domain " + domainName);
            }
            if (cnt + (max - min) >= values.length) {
                throw new FormatException("The number of values in the domain " + domainName + " is different from the value of nbValues.");
            }
            int i = min;
            while (i <= max) {
                values[cnt++] = i++;
            }
        }
        if (st.hasMoreTokens()) {
            throw new FormatException("The number of values in the domain " + domainName + " is different from the value of nbValues.");
        }
        for (int i = 1; i < values.length; ++i) {
            if (values[i - 1] < values[i]) continue;
            throw new FormatException("In domain " + domainName + ", the two values " + values[i - 1] + " and " + values[i] + " are either equal or not given in increasing order");
        }
        return values;
    }

    private PDomain parseDomain(Element domainElement) throws FormatException {
        String name = domainElement.getAttribute("name");
        this.checkAndRecord(name, "domain");
        int nbValues = this.parseStrictlyPositiveInt("nbValues of domain " + name + " ", domainElement.getAttribute("nbValues"));
        return new PDomain(name, this.parseDomainValues(name, nbValues, domainElement.getTextContent()));
    }

    private void parseDomains(Element domainsElement) throws FormatException {
        if (domainsElement == null) {
            throw new FormatException("The element domains is absent.");
        }
        this.mapOfDomains = new HashMap<String, PDomain>();
        int nbDomains = this.parseStrictlyPositiveInt("nbDomains of element domains ", domainsElement.getAttribute("nbDomains"));
        this.domainNames = new String[nbDomains];
        NodeList nodeList = domainsElement.getElementsByTagName("domain");
        if (nbDomains != nodeList.getLength()) {
            throw new FormatException("the value of nbDomains does not correspond to the number of domains");
        }
        for (int i = 0; i < nodeList.getLength(); ++i) {
            PDomain domain = this.parseDomain((Element)nodeList.item(i));
            this.mapOfDomains.put(domain.getName(), domain);
            this.domainNames[i] = domain.getName();
        }
    }

    private PVariable parseVariable(Element variableElement) throws FormatException {
        String name = variableElement.getAttribute("name");
        this.checkAndRecord(name, "variable");
        String domainName = variableElement.getAttribute("domain");
        PDomain domain = this.mapOfDomains.get(domainName);
        if (domain == null) {
            throw new FormatException("variable " + name + " has an unknown associated domain " + domainName);
        }
        return new PVariable(name, domain);
    }

    private void parseVariables(Element variablesElement) throws FormatException {
        if (variablesElement == null) {
            throw new FormatException("The element variables is absent.");
        }
        this.mapOfVariables = new HashMap<String, PVariable>();
        int nbVariables = this.parseStrictlyPositiveInt("nbVariables of element variables ", variablesElement.getAttribute("nbVariables"));
        this.variableNames = new String[nbVariables];
        NodeList nodeList = variablesElement.getElementsByTagName("variable");
        if (nbVariables != nodeList.getLength()) {
            throw new FormatException("the value of nbVariables does not correspond to the number of variables");
        }
        for (int i = 0; i < nodeList.getLength(); ++i) {
            PVariable variable = this.parseVariable((Element)nodeList.item(i));
            this.mapOfVariables.put(variable.getName(), variable);
            this.variableNames[i] = variable.getName();
        }
    }

    private String listOf(int[] t, int limit) {
        String s = "(";
        for (int i = 0; i < limit; ++i) {
            s = s + t[i] + (i < limit - 1 ? " " : ")");
        }
        return s;
    }

    private String getStringOf(int[] t) {
        StringBuffer sb = new StringBuffer();
        sb.append('(');
        for (int i = 0; i < t.length; ++i) {
            sb.append(t[i] + (i < t.length - 1 ? "," : ""));
        }
        sb.append(')');
        return sb.toString();
    }

    private int[][] parseTuples(String name, int nbTuples, int arity, String semantics, String s) throws FormatException {
        int i;
        int[][] tuples = new int[nbTuples][arity];
        if (semantics.equals("soft")) {
            this.weights = new int[nbTuples];
        }
        int currentCost = -2;
        StringTokenizer st1 = new StringTokenizer(s, "|");
        for (i = 0; st1.hasMoreTokens() && i < nbTuples; ++i) {
            StringTokenizer st2 = new StringTokenizer(st1.nextToken().trim());
            String token = st2.nextToken();
            if (semantics.equals("soft")) {
                int costFlagPosition = token.lastIndexOf(":");
                if (costFlagPosition != -1) {
                    currentCost = this.parseInt("Problem with the cost in " + token + " of relation " + name, token.substring(0, costFlagPosition));
                    token = token.substring(costFlagPosition + 1);
                }
                if (currentCost < 0) {
                    throw new FormatException("No cost (or a negative cost) is associated with a tuple in relation " + name);
                }
                this.weights[i] = currentCost;
            }
            tuples[i][0] = this.parseInt("Problem with the token " + token + " in relation " + name, token);
            int j = 1;
            while (st2.hasMoreTokens() && j < arity) {
                tuples[i][j++] = this.parseInt("Problem  with a tuple in relation " + name, st2.nextToken());
            }
            if (j < arity || st2.hasMoreTokens()) {
                throw new FormatException("There is a problem with tuple starting with " + this.listOf(tuples[i], j) + " in relation " + name + ". It has a size different from the indicated arity.");
            }
            if (i <= 0 || Toolkit.lexicographicComparator.compare(tuples[i - 1], tuples[i]) < 0) continue;
            throw new FormatException("In relation " + name + ", the two tuples " + this.getStringOf(tuples[i - 1]) + " and " + this.getStringOf(tuples[i]) + " are either equal or not given in lexicographic order: ");
        }
        if (i < nbTuples || st1.hasMoreTokens()) {
            throw new FormatException("The number of tuples in relation " + name + (i < nbTuples ? ", which is " + i : ", which is greater than " + nbTuples) + ", is different from nbTuples = " + nbTuples);
        }
        return tuples;
    }

    private PRelation parseRelation(Element relationElement) throws FormatException {
        String name = relationElement.getAttribute("name");
        this.checkAndRecord(name, "relation");
        int arity = this.parseStrictlyPositiveInt("arity of relation " + name + " ", relationElement.getAttribute("arity"));
        int nbTuples = this.parsePositiveInt("nbTuples of relation " + name + " ", relationElement.getAttribute("nbTuples"));
        String semantics = relationElement.getAttribute("semantics");
        if (semantics.equals("soft")) {
            if (!this.type.equals("WCSP")) {
                throw new FormatException("There is a soft relation whose name is " + name + " in the instance but the type is not declared as WCSP");
            }
        } else if (!semantics.equals("supports") && !semantics.equals("conflicts")) {
            throw new FormatException("There is a bad (or missing) value of the semantics attribute for the relation " + name);
        }
        int[][] tuples = this.parseTuples(name, nbTuples, arity, semantics, relationElement.getTextContent());
        if (semantics.equals("soft")) {
            String s = relationElement.getAttribute("defaultCost");
            int defaultCost = s.equals("infinity") ? Integer.MAX_VALUE : this.parsePositiveInt("pb with defaultCost " + s + " of relation " + name, s);
            return new PRelation(name, arity, nbTuples, semantics, tuples, this.weights, defaultCost);
        }
        return new PRelation(name, arity, nbTuples, semantics, tuples);
    }

    private void parseRelations(Element relationsElement) throws FormatException {
        this.mapOfRelations = new HashMap<String, PRelation>();
        if (relationsElement == null) {
            this.relationNames = new String[0];
            return;
        }
        int nbRelations = this.parsePositiveInt("nbRelations of element relations ", relationsElement.getAttribute("nbRelations"));
        this.relationNames = new String[nbRelations];
        NodeList nodeList = relationsElement.getElementsByTagName("relation");
        if (nbRelations != nodeList.getLength()) {
            throw new FormatException("the value of nbRelations does not correspond to the number of relations which is " + nodeList.getLength());
        }
        for (int i = 0; i < nodeList.getLength(); ++i) {
            PRelation relation = this.parseRelation((Element)nodeList.item(i));
            this.mapOfRelations.put(relation.getName(), relation);
            this.relationNames[i] = relation.getName();
        }
    }

    private PPredicate parsePredicate(Element predicateElement) throws FormatException {
        String name = predicateElement.getAttribute("name");
        this.checkAndRecord(name, "predicate");
        Element parameters = XMLManager.getElementByTagNameFrom(predicateElement, "parameters", 0);
        if (parameters == null) {
            throw new FormatException("Missing parameters child element in predicate " + name);
        }
        Element expression = XMLManager.getElementByTagNameFrom(predicateElement, "expression", 0);
        if (expression == null) {
            throw new FormatException("Missing expression child element in predicate " + name);
        }
        Element functional = XMLManager.getElementByTagNameFrom(expression, "functional", 0);
        if (functional == null) {
            throw new FormatException("Missing functional child element in predicate " + name);
        }
        try {
            PPredicate predicate = new PPredicate(name, parameters.getTextContent(), functional.getTextContent());
            if (predicate.getFormalParameters() == null) {
                throw new FormatException("Predicate " + name + " involves twice a formal parameter ");
            }
            EvaluationManager evaluationManager = new EvaluationManager(predicate.getUniversalPostfixExpression());
            if (!evaluationManager.controlArityOfEvaluators() || !evaluationManager.controlTypeOfEvaluators()) {
                throw new FormatException("ill-formed expression " + functional.getTextContent() + " of predicate " + name);
            }
            return predicate;
        }
        catch (Exception e) {
            throw new FormatException("ill-formed expression " + functional.getTextContent() + " of predicate " + name);
        }
    }

    private void parsePredicates(Element predicatesElement) throws FormatException {
        this.mapOfPredicates = new HashMap<String, PPredicate>();
        if (predicatesElement == null) {
            this.predicateNames = new String[0];
            return;
        }
        int nbPredicates = this.parsePositiveInt("nbPredicates of element predicates ", predicatesElement.getAttribute("nbPredicates"));
        this.predicateNames = new String[nbPredicates];
        NodeList nodeList = predicatesElement.getElementsByTagName("predicate");
        if (nbPredicates != nodeList.getLength()) {
            throw new FormatException("the value of nbPredicates does not correspond to the number of predicates");
        }
        for (int i = 0; i < nodeList.getLength(); ++i) {
            PPredicate predicate = this.parsePredicate((Element)nodeList.item(i));
            this.mapOfPredicates.put(predicate.getName(), predicate);
            this.predicateNames[i] = predicate.getName();
        }
    }

    private int searchIn(String s, PVariable[] variables) {
        for (int i = 0; i < variables.length; ++i) {
            if (!variables[i].getName().equals(s)) continue;
            return i;
        }
        return -1;
    }

    private void checkEffectiveParameters(String name, PVariable[] variables, String[] parameters) throws FormatException {
        boolean[] found = new boolean[variables.length];
        for (String token : parameters) {
            Long l = Toolkit.parseLong(token);
            if (l != null) continue;
            int position = this.searchIn(token, variables);
            if (position != -1) {
                found[position] = true;
                continue;
            }
            throw new FormatException("The effective parameter " + token + " does not correspond to an integer or an involved variable of constraint " + name);
        }
        for (int i = 0; i < found.length; ++i) {
            if (found[i]) continue;
            throw new FormatException("The variable " + variables[i].getName() + " does not occur in the list of effective parameters of constraint " + name);
        }
    }

    private int searchIn(PVariable v, PVariable[] variables) {
        for (int i = 0; i < variables.length; ++i) {
            if (variables[i] != v) continue;
            return i;
        }
        return -1;
    }

    private PVariable[] controlInvolvedVariablesWrtScope(List<PVariable> involvedVariablesInParameters, PVariable[] scope, String name) throws FormatException {
        PVariable[] t = involvedVariablesInParameters.toArray(new PVariable[involvedVariablesInParameters.size()]);
        if (t.length != scope.length) {
            throw new FormatException("The number of variables occuring in scope is different from the number of variables occuring in parameters of constraint " + name);
        }
        for (int i = 0; i < scope.length; ++i) {
            if (this.searchIn(scope[i], t) != -1) continue;
            throw new FormatException("One variable of the scope of constraint " + name + " does not occur in parameters.");
        }
        return t;
    }

    private PConstraint parseElementConstraint(String name, PVariable[] scope, Element parameters) throws FormatException {
        StringTokenizer st = new StringTokenizer(Toolkit.insertWhitespaceAround(parameters.getTextContent(), "[]{}"));
        ArrayList<PVariable> involvedVariablesInParameters = new ArrayList<PVariable>();
        PVariable index = this.mapOfVariables.get(this.nextToken(name, st));
        involvedVariablesInParameters.add(index);
        if (!this.nextToken(name, st).equals("[")) {
            throw new FormatException("One should find [ as second token of the parameters of constraint " + name);
        }
        ArrayList<PVariable> table = new ArrayList<PVariable>();
        String token = this.nextToken(name, st);
        while (!token.equals("]")) {
            Object object = this.mapOfVariables.get(token);
            if (object == null) {
                object = this.parseInt("Pb with a token in parameters of table of constraint Element " + name, token);
            } else {
                involvedVariablesInParameters.add((PVariable)object);
            }
            table.add((PVariable)object);
            token = this.nextToken(name, st);
        }
        token = this.nextToken(name, st);
        Object value = this.mapOfVariables.get(token);
        if (value == null) {
            value = this.parseInt("Pb with the value token in parameters of constraint Element " + name, token);
        } else {
            involvedVariablesInParameters.add((PVariable)value);
        }
        if (st.hasMoreTokens()) {
            throw new FormatException("Too many tokens in the parameters of constraint " + name);
        }
        this.controlInvolvedVariablesWrtScope(involvedVariablesInParameters, scope, name);
        return new PElement(name, scope, index, table.toArray(new Object[table.size()]), value);
    }

    private PConstraint parseWeightedSumConstraint(String name, PVariable[] scope, Element parameters) throws FormatException {
        NodeList nodeList = parameters.getChildNodes();
        if (nodeList.getLength() != 3) {
            throw new FormatException("Ill-formed parameters of constraint " + name);
        }
        StringTokenizer st = new StringTokenizer(Toolkit.insertWhitespaceAround(nodeList.item(0).getTextContent(), "[]{}"));
        int[] coeffs = new int[scope.length];
        if (!this.nextToken(name, st).equals("[")) {
            throw new FormatException("One should find [ as first token of the parameters of constraint " + name);
        }
        String token = this.nextToken(name, st);
        while (!token.equals("]")) {
            if (!token.equals("{")) {
                throw new FormatException("One should find { as first token of a pair (coefficient, variable) in constraint " + name);
            }
            String coeffToken = this.nextToken(name, st);
            int position = this.searchIn(this.nextToken(name, st), scope);
            if (position == -1) {
                throw new FormatException("Ill-formed parameters of constraint " + name);
            }
            int n = position;
            coeffs[n] = coeffs[n] + this.parseInt("One coefficient " + token + " of the parameters of constraint " + name, coeffToken);
            if (!this.nextToken(name, st).equals("}")) {
                throw new FormatException("One should find } as last token of a pair (coefficient, variable) in constraint " + name);
            }
            token = this.nextToken(name, st);
        }
        for (int i = 0; i < coeffs.length; ++i) {
            if (coeffs[i] != 0) continue;
            throw new FormatException("One variable is not associated with a coefficient in constraint " + name);
        }
        PredicateTokens.RelationalOperator operator = PredicateTokens.RelationalOperator.getRelationalOperatorFor(nodeList.item(1).getNodeName());
        if (operator == null) {
            throw new FormatException("Relational operator in parameters of constraint " + name);
        }
        int limit = this.parseInt("limit value for weightedSum constraint " + name, nodeList.item(2).getTextContent().trim());
        return new PWeightedSum(name, scope, coeffs, operator, limit);
    }

    private String buildStringRepresentationOf(Element parameters) {
        NodeList nodeList = parameters.getChildNodes();
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            if (node.getNodeName().equals("nil")) {
                sb.append(" ");
                sb.append("nil");
                sb.append(" ");
                continue;
            }
            sb.append(Toolkit.insertWhitespaceAround(node.getTextContent(), "[]{}"));
        }
        return sb.toString();
    }

    private PConstraint parseCumulativeConstraint(String name, PVariable[] involvedVariables, Element parameters) throws FormatException {
        StringTokenizer st = new StringTokenizer(this.buildStringRepresentationOf(parameters));
        if (!this.nextToken(name, st).equals("[")) {
            throw new FormatException("One should find [ as first token of the parameters of constraint " + name);
        }
        ArrayList<PVariable> involvedVariablesInParameters = new ArrayList<PVariable>();
        String token = this.nextToken(name, st);
        ArrayList<PCumulative.Task> tasks = new ArrayList<PCumulative.Task>();
        while (!token.equals("]")) {
            if (!token.equals("{")) {
                throw new FormatException("One should find { as first token of a task definition in constraint " + name);
            }
            token = this.nextToken(name, st);
            PVariable origin = this.mapOfVariables.get(token);
            if (origin == null) {
                origin = token.equals("nil") ? null : Integer.valueOf(this.parseInt("origin field " + token + " in the parameters of constraint " + name, token));
            } else {
                involvedVariablesInParameters.add(origin);
            }
            token = this.nextToken(name, st);
            PVariable duration = this.mapOfVariables.get(token);
            if (duration == null) {
                duration = token.equals("nil") ? null : Integer.valueOf(this.parseInt("duration field " + token + " in the parameters of constraint " + name, token));
            } else {
                involvedVariablesInParameters.add(duration);
            }
            token = this.nextToken(name, st);
            PVariable end = this.mapOfVariables.get(token);
            if (end == null) {
                end = token.equals("nil") ? null : Integer.valueOf(this.parseInt("end field " + token + " in the parameters of constraint " + name, token));
            } else {
                involvedVariablesInParameters.add(end);
            }
            token = this.nextToken(name, st);
            Object height = this.mapOfVariables.get(token);
            if (height == null) {
                height = this.parseInt("height field " + token + " in the parameters of constraint " + name, token);
            } else {
                involvedVariablesInParameters.add((PVariable)height);
            }
            token = this.nextToken(name, st);
            if (!token.equals("}")) {
                throw new FormatException("One should find } as last token of a task definition in constraint " + name);
            }
            if (origin == null && duration == null || origin == null && end == null || duration == null && end == null) {
                throw new FormatException("Only one field may be absent in {origin,duration,end} in a task definition of constraint " + name);
            }
            tasks.add(new PCumulative.Task(origin, duration, end, height));
            token = this.nextToken(name, st);
        }
        this.controlInvolvedVariablesWrtScope(involvedVariablesInParameters, involvedVariables, name);
        int limit = this.parseInt("limit value for cumulative constraint " + name, this.nextToken(name, st));
        if (st.hasMoreTokens()) {
            throw new FormatException("Too many tokens in the parameters of constraint " + name);
        }
        return new PCumulative(name, involvedVariables, tasks.toArray(new PCumulative.Task[tasks.size()]), limit);
    }

    private PConstraint parseConstraint(Element constraintElement) throws FormatException {
        String name = constraintElement.getAttribute("name");
        this.checkAndRecord(name, "constraint");
        int arity = this.parseStrictlyPositiveInt("arity of constraint " + name + " ", constraintElement.getAttribute("arity"));
        String scope = constraintElement.getAttribute("scope");
        if (scope.length() == 0) {
            throw new FormatException("There is no scope attribute for constraint " + name);
        }
        String reference = constraintElement.getAttribute("reference");
        if (reference.length() == 0) {
            throw new FormatException("There is no reference attribute for constraint " + name);
        }
        StringTokenizer st = new StringTokenizer(scope);
        PVariable[] involvedVariables = new PVariable[st.countTokens()];
        if (arity != involvedVariables.length) {
            throw new FormatException("The number of variables in the scope of constraint " + name + " does not correspond to the indicated arity");
        }
        for (int i = 0; i < involvedVariables.length; ++i) {
            String variableName = st.nextToken();
            PVariable variable = this.mapOfVariables.get(variableName);
            if (variable == null) {
                throw new FormatException("constraint " + name + " involves the unknown variable " + variableName);
            }
            boolean found = false;
            for (int j = 0; j < i; ++j) {
                if (involvedVariables[j] != variable) continue;
                found = true;
            }
            if (found) {
                throw new FormatException("Constraint " + name + " involves twice the variable " + variableName);
            }
            involvedVariables[i] = variable;
        }
        if (this.mapOfRelations.containsKey(reference)) {
            if (arity != this.mapOfRelations.get(reference).getArity()) {
                throw new FormatException("The arity of constraint " + name + " does not correspond to the arity of the referenced relation.");
            }
            return new PExtensionConstraint(name, involvedVariables, this.mapOfRelations.get(reference));
        }
        if (this.mapOfPredicates.containsKey(reference)) {
            Element parameters = XMLManager.getElementByTagNameFrom(constraintElement, "parameters", 0);
            String[] effectiveParameters = Toolkit.buildTokensFromString(parameters.getTextContent());
            if (effectiveParameters.length != this.mapOfPredicates.get(reference).getFormalParameters().length) {
                throw new FormatException("The number of effective parameters of constraint " + name + " does not correspond to the number of formal parameters of the referenced predicate.");
            }
            this.checkEffectiveParameters(name, involvedVariables, effectiveParameters);
            return new PIntensionConstraint(name, involvedVariables, this.mapOfPredicates.get(reference), parameters.getTextContent());
        }
        String lreference = reference.toLowerCase();
        Element parameters = (Element)constraintElement.getElementsByTagName("parameters").item(0);
        if (lreference.equals(InstanceTokens.getLowerCaseGlobalNameOf("allDifferent"))) {
            return new PAllDifferent(name, involvedVariables);
        }
        if (lreference.equals(InstanceTokens.getLowerCaseGlobalNameOf("element"))) {
            return this.parseElementConstraint(name, involvedVariables, parameters);
        }
        if (lreference.equals(InstanceTokens.getLowerCaseGlobalNameOf("weightedSum"))) {
            return this.parseWeightedSumConstraint(name, involvedVariables, parameters);
        }
        if (lreference.equals(InstanceTokens.getLowerCaseGlobalNameOf("cumulative"))) {
            return this.parseCumulativeConstraint(name, involvedVariables, parameters);
        }
        throw new FormatException("There is an unknown reference " + reference + " for constraint " + name);
    }

    private void parseConstraints(Element constraintsElement) throws FormatException {
        if (constraintsElement == null) {
            throw new FormatException("The element constraints is absent.");
        }
        this.mapOfConstraints = new HashMap<String, PConstraint>();
        int nbConstraints = this.parseStrictlyPositiveInt("nbConstraints of element constraints ", constraintsElement.getAttribute("nbConstraints"));
        this.constraintNames = new String[nbConstraints];
        NodeList nodeList = constraintsElement.getElementsByTagName("constraint");
        if (nbConstraints != nodeList.getLength()) {
            throw new FormatException("the value of nbConstraints does not correspond to the number of constraints which is " + nodeList.getLength());
        }
        for (int i = 0; i < nodeList.getLength(); ++i) {
            PConstraint constraint = this.parseConstraint((Element)nodeList.item(i));
            this.mapOfConstraints.put(constraint.getName(), constraint);
            this.constraintNames[i] = constraint.getName();
        }
        if (this.type.equals("WCSP")) {
            int initialCost;
            String s = constraintsElement.getAttribute("maximalCost");
            int maximalCost = s.equals("infinity") ? Integer.MAX_VALUE : this.parseStrictlyPositiveInt("pb with maximalCost " + s, s);
            s = constraintsElement.getAttribute("initialCost");
            int n = initialCost = s.equals("") ? 0 : this.parsePositiveInt("pb with initialCost " + s, s);
            if (initialCost >= maximalCost) {
                throw new FormatException("InitialCost is greater than maximalCost");
            }
            if (this.competitionControl && maximalCost == Integer.MAX_VALUE) {
                throw new FormatException("InitialCost or maximalCost does not respect restrictions of the 2008 competition");
            }
            for (PRelation relation : this.mapOfRelations.values()) {
                int max = relation.getDefaultCost();
                for (int w : relation.getWeights()) {
                    if (w <= max) continue;
                    max = w;
                }
                if (max <= maximalCost) continue;
                throw new FormatException("A tuple (or defaultCost) in relation " + relation.getName() + " has a cost strictly greater than maximalCost");
            }
        }
    }

    private void controlOrderOfElements(Document document) throws FormatException {
        if (!DocumentModifier.areOrderedChilds(document, "presentation", "domains")) {
            throw new FormatException("Element <presentation> should be before element <domains>");
        }
        if (!DocumentModifier.areOrderedChilds(document, "domains", "variables")) {
            throw new FormatException("Element <domains> should be before element <variables>");
        }
        if (DocumentModifier.isPresentChild(document, "relations") && !DocumentModifier.areOrderedChilds(document, "variables", "relations")) {
            throw new FormatException("Element <variables> should be before element <relations>");
        }
        if (DocumentModifier.isPresentChild(document, "predicates") && !DocumentModifier.areOrderedChilds(document, "variables", "predicates")) {
            throw new FormatException("Element <variables> should be before element <predicates>");
        }
        if (DocumentModifier.isPresentChild(document, "relations") && !DocumentModifier.areOrderedChilds(document, "relations", "constraints")) {
            throw new FormatException("Element <relations> should be before element <constraints>");
        }
        if (DocumentModifier.isPresentChild(document, "predicates") && !DocumentModifier.areOrderedChilds(document, "predicates", "constraints")) {
            throw new FormatException("Element <predicates> should be before element <constraints>");
        }
    }

    public InstanceCheckerParser(InstanceCheckerEngine logic, Document document, boolean competitionControl) throws FormatException {
        this.engine = logic;
        this.competitionControl = competitionControl;
        this.controlOrderOfElements(document);
        this.allNameIdentifiers = new HashSet<String>();
        this.parsePresentation(XMLManager.getFirstElementByTagNameFromRoot(document, "presentation"));
        logic.spot();
        this.parseDomains(XMLManager.getFirstElementByTagNameFromRoot(document, "domains"));
        logic.spot();
        this.parseVariables(XMLManager.getFirstElementByTagNameFromRoot(document, "variables"));
        logic.spot();
        this.parseRelations(XMLManager.getFirstElementByTagNameFromRoot(document, "relations"));
        logic.spot();
        this.parsePredicates(XMLManager.getFirstElementByTagNameFromRoot(document, "predicates"));
        logic.spot();
        this.parseConstraints(XMLManager.getFirstElementByTagNameFromRoot(document, "constraints"));
    }

    private boolean isDomainReferenced(PDomain domain) {
        for (PVariable variable : this.mapOfVariables.values()) {
            if (variable.getDomain() != domain) continue;
            return true;
        }
        return false;
    }

    private void checkValidityOfDomains() throws FormatException {
        for (PDomain domain : this.mapOfDomains.values()) {
            if (this.isDomainReferenced(domain)) continue;
            throw new FormatException("the domain " + domain.getName() + " is never referenced by a variable");
        }
        if (this.competitionControl) {
            for (int i = 0; i < this.domainNames.length; ++i) {
                if (this.domainNames[i].equals(InstanceTokens.getDomainNameFor(i))) continue;
                throw new FormatException("the " + (i + 1) + "th domain is not called " + InstanceTokens.getDomainNameFor(i));
            }
        }
    }

    private void checkValidityOfVariables() throws FormatException {
        if (this.competitionControl) {
            for (int i = 0; i < this.variableNames.length; ++i) {
                if (this.variableNames[i].equals(InstanceTokens.getVariableNameFor(i))) continue;
                throw new FormatException("the " + (i + 1) + "th variable is not called " + InstanceTokens.getVariableNameFor(i));
            }
        }
    }

    private boolean isRelationReferenced(PRelation relation) {
        for (PConstraint constraint : this.mapOfConstraints.values()) {
            if (!(constraint instanceof PExtensionConstraint) || ((PExtensionConstraint)constraint).getRelation() != relation) continue;
            return true;
        }
        return false;
    }

    private void checkValidityOfRelations() throws FormatException {
        for (PRelation relation : this.mapOfRelations.values()) {
            if (this.isRelationReferenced(relation)) continue;
            throw new FormatException("the relation " + relation.getName() + " is never referenced by a constraint");
        }
        if (this.competitionControl) {
            for (int i = 0; i < this.relationNames.length; ++i) {
                if (this.relationNames[i].equals(InstanceTokens.getRelationNameFor(i))) continue;
                throw new FormatException("the " + (i + 1) + "th relation is not called " + InstanceTokens.getRelationNameFor(i));
            }
        }
    }

    private boolean isPredicateReferenced(PPredicate predicate) {
        for (PConstraint constraint : this.mapOfConstraints.values()) {
            if (!(constraint instanceof PIntensionConstraint) || ((PIntensionConstraint)constraint).getPredicate() != predicate) continue;
            return true;
        }
        return false;
    }

    private void checkValidityOfPredicates() throws FormatException {
        for (PPredicate predicate : this.mapOfPredicates.values()) {
            if (this.isPredicateReferenced(predicate)) continue;
            throw new FormatException("the predicate " + predicate.getName() + " is never referenced by a constraint");
        }
        if (this.competitionControl) {
            for (int i = 0; i < this.predicateNames.length; ++i) {
                if (this.predicateNames[i].equals(InstanceTokens.getPredicateNameFor(i))) continue;
                throw new FormatException("the " + (i + 1) + "th predicate is not called " + InstanceTokens.getPredicateNameFor(i));
            }
            for (PPredicate predicate : this.mapOfPredicates.values()) {
                String[] formalParameters = predicate.getFormalParameters();
                for (int i = 0; i < formalParameters.length; ++i) {
                    if (formalParameters[i].equals(InstanceTokens.getParameterNameFor(i))) continue;
                    throw new FormatException("the " + (i + 1) + "th formal parameter of " + predicate.getName() + " is not called " + InstanceTokens.getParameterNameFor(i));
                }
            }
        }
    }

    private void checkValidityOfConstraints() throws FormatException {
        for (PConstraint constraint : this.mapOfConstraints.values()) {
            int[][] tuples;
            if (!(constraint instanceof PExtensionConstraint)) continue;
            PVariable[] scope = constraint.getScope();
            PRelation relation = ((PExtensionConstraint)constraint).getRelation();
            for (int[] tuple : tuples = relation.getTuples()) {
                for (int i = 0; i < tuple.length; ++i) {
                    if (scope[i].getDomain().contains(tuple[i])) continue;
                    throw new FormatException("The value " + tuple[i] + " that belongs to a tuple of the referenced relation does not belong to the domain of the variable " + scope[i].getName() + " involved in constraint " + constraint.getName());
                }
            }
        }
        if (this.competitionControl) {
            for (int i = 0; i < this.constraintNames.length; ++i) {
                if (this.constraintNames[i].equals(InstanceTokens.getConstraintNameFor(i))) continue;
                throw new FormatException("the " + (i + 1) + "th constraint is not called " + InstanceTokens.getConstraintNameFor(i));
            }
            long sumL = 0L;
            double sumD = 0.0;
            for (PConstraint constraint : this.mapOfConstraints.values()) {
                if (constraint.getArity() < 1) {
                    throw new FormatException("contraint " + constraint.getName() + " has an arity less than 1");
                }
                if (!constraint.isGuaranteedToBeDivisionByZeroFree()) {
                    throw new FormatException("the constraint " + constraint.getName() + " is not guaranteed (by our rough analysis) to be division by zero free");
                }
                if (!constraint.isGuaranteedToBeOverflowFree()) {
                    throw new FormatException("the constraint " + constraint.getName() + " is not guaranteed (by our rough analysis) to be overflow free");
                }
                sumL += (long)constraint.getMaximalCost();
                sumD += (double)constraint.getMaximalCost();
            }
            if ((double)sumL != sumD || Double.isInfinite(sumD)) {
                throw new FormatException("the instance may involve an overflow computation when considering the maximal cost of an instantiation");
            }
        }
    }

    public void checkValidity() throws FormatException {
        this.checkValidityOfDomains();
        this.engine.spot();
        this.checkValidityOfVariables();
        this.engine.spot();
        this.checkValidityOfRelations();
        this.engine.spot();
        this.checkValidityOfPredicates();
        this.engine.spot();
        this.checkValidityOfConstraints();
    }

    private int[][] buildTuplesOf(PConstraint constraint, String[] canonicalPredicate) {
        int[][] values = new int[constraint.getArity()][];
        for (int i = 0; i < values.length; ++i) {
            values[i] = constraint.getScope()[i].getDomain().getValues();
        }
        LinkedList<Object> supports = new LinkedList<Object>();
        LinkedList<Object> conflicts = new LinkedList<Object>();
        EvaluationManager evaluationManager = new EvaluationManager(canonicalPredicate);
        LexicographicIterator li = new LexicographicIterator(values);
        int[] tuple = li.getFirstTuple();
        while (tuple != null) {
            if (evaluationManager.checkValues(tuple)) {
                supports.add(tuple.clone());
            } else {
                conflicts.add(tuple.clone());
            }
            tuple = li.getNextTupleAfter(tuple);
        }
        if (supports.size() <= conflicts.size()) {
            this.b = true;
            return (int[][])supports.toArray((T[])new int[0][0]);
        }
        this.b = false;
        return (int[][])conflicts.toArray((T[])new int[0][0]);
    }

    private PRelation getSimilarRelation(int arity, int nbTuples, String semantics, int[][] tuples) {
        for (PRelation relation : this.mapOfRelations.values()) {
            if (!relation.isSimilarTo(arity, nbTuples, semantics, tuples)) continue;
            return relation;
        }
        for (PRelation relation : this.newRelations) {
            if (!relation.isSimilarTo(arity, nbTuples, semantics, tuples)) continue;
            return relation;
        }
        return null;
    }

    private int getRelationNameFrom(int limit) {
        while (this.mapOfRelations.containsKey(InstanceTokens.getRelationNameFor(limit))) {
            ++limit;
        }
        return limit;
    }

    private int convert(PIntensionConstraint constraint, int limit) throws FormatException {
        int[][] tuples = this.buildTuplesOf(constraint, constraint.getUniversalPostfixExpression());
        String semantics = this.b ? "supports" : "conflicts";
        PRelation relation = this.getSimilarRelation(constraint.getArity(), tuples.length, semantics, tuples);
        if (relation == null) {
            limit = this.getRelationNameFrom(limit);
            relation = new PRelation(InstanceTokens.getRelationNameFor(limit), constraint.getArity(), tuples.length, semantics, tuples);
            this.newRelations.add(relation);
            ++limit;
        }
        this.constraintsToNewRelations.put(constraint.getName(), relation.getName());
        PExtensionConstraint c = new PExtensionConstraint(constraint.getName(), constraint.getScope(), relation);
        this.mapOfConstraints.put(c.getName(), c);
        return limit;
    }

    public void convertToExtension() throws FormatException {
        if (this.mapOfPredicates.size() == 0) {
            return;
        }
        this.newRelations = new ArrayList<PRelation>();
        this.constraintsToNewRelations = new HashMap<String, String>();
        int nbConvertions = 0;
        for (PConstraint constraint : this.mapOfConstraints.values()) {
            if (!(constraint instanceof PIntensionConstraint)) continue;
            ++nbConvertions;
        }
        int cpt = 0;
        int spotLimit = 1 + nbConvertions / 20;
        int limit = 0;
        for (PConstraint constraint : this.mapOfConstraints.values()) {
            if (!(constraint instanceof PIntensionConstraint)) continue;
            limit = this.convert((PIntensionConstraint)constraint, limit);
            if (++cpt % spotLimit != 0) continue;
            this.engine.spot();
        }
    }

    public void updateStructures() {
        this.mapOfPredicates.clear();
        this.predicateNames = new String[0];
        int nbOldRelations = this.mapOfRelations.size();
        String[] t = new String[nbOldRelations + this.newRelations.size()];
        for (int i = 0; i < nbOldRelations; ++i) {
            t[i] = this.relationNames[i];
        }
        Iterator<PRelation> it = this.newRelations.iterator();
        for (int i = nbOldRelations; i < t.length; ++i) {
            PRelation relation = it.next();
            t[i] = relation.getName();
            this.mapOfRelations.put(relation.getName(), relation);
        }
        this.relationNames = t;
    }

    static class FormatException
    extends Exception {
        private static final long serialVersionUID = -4742071198645091018L;

        public FormatException(String message) {
            super(message);
        }
    }
}

