/*
 * Decompiled with CFR 0.152.
 */
package parser.absconparseur.tools;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.PrintWriter;
import javax.swing.JOptionPane;
import org.w3c.dom.Document;
import parser.absconparseur.XMLManager;
import parser.absconparseur.tools.DocumentModifier;
import parser.absconparseur.tools.InstanceChecker;
import parser.absconparseur.tools.InstanceCheckerParser;

public class InstanceCheckerEngine
extends Thread {
    public static final String DEFAULT_PREFIX = "inst";
    private InstanceChecker checkerGraphic;
    private InstanceChecker.Indicator indicator;
    private File srcDirectory;
    private File dstDirectory;
    private boolean defaultFileName;
    private InstanceChecker.CHECKING_MODE mode;
    private int counter1 = 0;
    private int counter2 = 0;
    private int counter3 = 0;
    private boolean finished;
    private boolean overwrite;
    private boolean overwriteDecided;
    private boolean competitionControl;

    public void setOverwrite(boolean overwrite) {
        this.overwrite = overwrite;
    }

    public void setOverwriteDecided(boolean overwriteDecided) {
        this.overwriteDecided = overwriteDecided;
    }

    public InstanceCheckerEngine(InstanceChecker checkerGraphic, InstanceChecker.Indicator indicator, File srcDirectory, File dstDirectory, boolean defaultFileName, boolean competitionControl, InstanceChecker.CHECKING_MODE mode) {
        this.checkerGraphic = checkerGraphic;
        this.indicator = indicator;
        this.srcDirectory = srcDirectory;
        this.dstDirectory = dstDirectory;
        if (dstDirectory != null && !dstDirectory.exists()) {
            dstDirectory.mkdirs();
        }
        this.defaultFileName = defaultFileName;
        this.competitionControl = competitionControl;
        this.mode = mode;
    }

    public void setFinished(boolean b) {
        this.finished = b;
    }

    private boolean mustBeTreated(String fileName) {
        return (fileName = fileName.toLowerCase()).endsWith("xml") || fileName.endsWith("bz2");
    }

    private String valueOf(int cpt) {
        return (cpt < 10 ? "000" : (cpt < 100 ? "00" : (cpt < 1000 ? "0" : ""))) + cpt;
    }

    private String getNameOfFileToSave(File srcFile, boolean containsPredicatesBefore) {
        String basename;
        String string = basename = this.defaultFileName ? DEFAULT_PREFIX + this.valueOf(this.counter1) : srcFile.getName().substring(0, srcFile.getName().lastIndexOf("."));
        if (containsPredicatesBefore && this.mode == InstanceChecker.CHECKING_MODE.EXTENSIONAL) {
            return basename + "_ext.xml";
        }
        String suffix = ".xml";
        return basename + suffix;
    }

    private String getPathOfFileToSave(File srcFile, boolean containsPredicates) {
        if (this.srcDirectory.equals(this.dstDirectory)) {
            return srcFile.getParent();
        }
        if (this.defaultFileName) {
            return this.dstDirectory.getAbsolutePath();
        }
        return this.dstDirectory.getAbsolutePath() + File.separator + srcFile.getParent().replaceFirst(this.srcDirectory.getAbsolutePath(), "");
    }

    private PrintWriter buildPrintWriterFor(File srcFile, boolean containsPredicates) throws Exception {
        String fileName = this.getNameOfFileToSave(srcFile, containsPredicates);
        String pathName = this.getPathOfFileToSave(srcFile, containsPredicates);
        String absoluteFileName = pathName + File.separator + fileName;
        File f = new File(pathName);
        f.mkdirs();
        f = new File(f, fileName);
        if (f.exists()) {
            if (!this.overwriteDecided) {
                int result = JOptionPane.showConfirmDialog(null, "Do you want to overwrite ALL files (including " + fileName + ") ?", "", 0);
                this.overwrite = result == 0;
                this.overwriteDecided = true;
            }
            if (!this.overwrite) {
                fileName = fileName + ".new";
                absoluteFileName = pathName + File.separator + fileName;
            }
        }
        return new PrintWriter(new FileOutputStream(absoluteFileName));
    }

    public void treat(File srcFile) throws Exception {
        assert (srcFile.getName().toLowerCase().endsWith("xml") || srcFile.getName().toLowerCase().endsWith("xml.bz2"));
        DocumentModifier translator = new DocumentModifier();
        Document document = null;
        InstanceCheckerParser problem = null;
        this.indicator.write("    loading XML document " + srcFile.getName() + "...");
        if (srcFile.getName().toLowerCase().endsWith("xml.bz2")) {
            document = XMLManager.load(srcFile.getAbsolutePath());
        } else {
            FileInputStream in = new FileInputStream(srcFile);
            document = XMLManager.load(in, null);
            in.close();
        }
        this.indicator.write("ok\n");
        this.indicator.write("    building problem...");
        problem = new InstanceCheckerParser(this, document, this.competitionControl);
        this.indicator.write("ok\n");
        this.indicator.write("    checking validity...");
        problem.checkValidity();
        this.indicator.write("ok\n");
        if (this.mode == InstanceChecker.CHECKING_MODE.VALIDATION) {
            return;
        }
        boolean containsPredicateBefore = problem.getPredicatesMap().size() > 0;
        PrintWriter out = this.buildPrintWriterFor(srcFile, containsPredicateBefore);
        if (containsPredicateBefore && this.mode == InstanceChecker.CHECKING_MODE.EXTENSIONAL) {
            this.indicator.write("    converting predicates...");
            problem.convertToExtension();
            this.indicator.write("ok\n");
            this.indicator.write("    modifying XML document...");
            document = translator.modifyDocumentFrom(this, document, problem);
            problem.updateStructures();
            this.indicator.write("ok\n");
        }
        this.indicator.write("    setting to canonical form...");
        document = translator.setCanonicalFormOf(this, document, problem.hasCanonicalNames());
        this.indicator.write("ok\n");
        problem = null;
        this.indicator.write("    saving " + this.getNameOfFileToSave(srcFile, containsPredicateBefore) + "...");
        XMLManager.save(document, out, XMLManager.class.getResourceAsStream("instance_2_0.xsl"));
        this.indicator.write("ok\n");
        out.close();
    }

    private void operateFile(File srcFile) {
        if (!this.mustBeTreated(srcFile.getName())) {
            System.out.println(srcFile.getAbsolutePath() + " ignored");
            ++this.counter3;
        } else {
            this.indicator.write(srcFile.getName() + "\n");
            try {
                this.treat(srcFile);
                ++this.counter1;
            }
            catch (Exception e) {
                ++this.counter2;
                this.indicator.write("  ERROR as " + e.getMessage() + " " + "\n");
            }
        }
        if (this.checkerGraphic != null) {
            this.checkerGraphic.updateCounters(this.counter1, this.counter2, this.counter3);
        }
    }

    private void operateDirectory(File dir) {
        String[] list = dir.list();
        for (int i = 0; i < list.length; ++i) {
            this.operate(new File(dir, list[i]));
        }
    }

    private void operate(File file) {
        if (this.finished) {
            return;
        }
        if (!file.isDirectory()) {
            this.operateFile(file);
        } else {
            this.operateDirectory(file);
        }
    }

    @Override
    public void run() {
        long start = System.currentTimeMillis();
        try {
            this.overwriteDecided = false;
            this.operate(this.srcDirectory);
        }
        catch (OutOfMemoryError e) {
            this.indicator.write(" OUT OF MEMORY ERROR - the program is going to be stopped");
            System.out.println("OUT OF MEMORY ERROR - the program has been stopped");
            System.exit(1);
        }
        long stop = System.currentTimeMillis();
        if (this.checkerGraphic != null) {
            this.checkerGraphic.endOfCoder(this.counter1, this.counter2, this.counter3, stop - start);
        }
    }

    public void spot() {
        this.indicator.write(".");
    }

    public void write(String s) {
        this.indicator.write(s);
    }
}

