/*
 * Decompiled with CFR 0.152.
 */
package parser.absconparseur.tools;

import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import parser.absconparseur.tools.InstanceCheckerEngine;

public class InstanceChecker
extends JFrame {
    private static final long serialVersionUID = -3961722178499026262L;
    private InstanceCheckerEngine coder;
    private final MyPanel content = new MyPanel();
    private Indicator indicator;

    public void updateCounters(int nb1, int nb2, int nb3) {
        this.content.counter1Field.setText("" + nb1);
        this.content.counter2Field.setText("" + nb2);
        this.content.counter3Field.setText("" + nb3);
    }

    public void endOfCoder(int nb1, int nb2, int nb3, long duration) {
        this.updateCounters(nb1, nb2, nb3);
        this.content.stopButton.setEnabled(false);
        this.content.startButton.setEnabled(true);
    }

    public InstanceChecker() {
        Dimension d = Toolkit.getDefaultToolkit().getScreenSize();
        this.setTitle("InstanceChecker");
        this.setContentPane(this.content);
        this.indicator = new IndicatorGUI(this.content);
        this.setDefaultCloseOperation(3);
        this.pack();
        this.setLocation((d.width - this.getWidth()) / 2, (d.height - this.getHeight()) / 2);
        this.setVisible(true);
    }

    public static void main(String[] args) throws Exception {
        if (args.length == 2 || args.length == 3) {
            try {
                File srcDirectory;
                File file = new File(args[0]);
                if (file.isDirectory()) {
                    System.err.println("PROBLEM \t you must give the name of a file (and not the name of a directory)");
                    System.exit(2);
                }
                if (!file.exists()) {
                    System.err.println("PROBLEM \t the file has not been found");
                    System.exit(2);
                }
                file = file.getAbsoluteFile();
                File dstDirectory = srcDirectory = new File(file.getPath());
                int arg = Integer.parseInt(args[1]);
                boolean competitionControl = arg == 2;
                CHECKING_MODE mode = CHECKING_MODE.getOperatorFor(arg);
                Indicator indicator = new Indicator(){

                    @Override
                    public void write(String text) {
                    }
                };
                InstanceCheckerEngine coder = new InstanceCheckerEngine(null, indicator, srcDirectory, dstDirectory, false, competitionControl, mode);
                coder.setOverwriteDecided(true);
                coder.setOverwrite(args.length == 3 && (arg == 3 || arg == 4) && args[2].charAt(0) == 'y');
                try {
                    coder.treat(file);
                }
                catch (Exception e) {
                    System.out.println("ERROR \t the instance is not valid: " + e.getMessage());
                    System.exit(1);
                }
                System.out.println("OK \t (the instance is valid" + (arg != 3 ? ")" : " - including additional rules of the 2008 competition of CSP solvers)"));
                System.exit(0);
            }
            catch (Throwable e) {
                System.err.println("PROBLEM \t " + e.getMessage());
                e.printStackTrace();
                System.exit(2);
            }
        }
        if (args.length == 1 && args[0].toLowerCase().equals("gui")) {
            new InstanceChecker();
        } else {
            System.out.println("InstanceChecker version 2.1.2 (March 30, 2008)");
            System.out.println("Usage 1 : java ... InstanceChecker gui");
            System.out.println("Usage 2 : java ... InstanceChecker <instanceFileName> <mode> {<overwrite>}");
            System.out.println();
            System.out.println("With Usage 1, InstanceChecker displays a graphical user interface (gui)");
            System.out.println("With Usage 2, you run a simple command line:");
            System.out.println("  with mode = 1, you can check the validity of the given instance");
            System.out.println("  with mode = 2, you can check the validity of the given instance (including additional rules of the 2008 competition of CSP solvers)");
            System.out.println("  with mode = 3, you can check (not including additional 2008 competition rules) and convert the given instance into canonical form");
            System.out.println("  with mode = 4, you can check (not including additional 2008 competition rules) and convert the given instance into canonical extensional form");
            System.out.println("NB: with mode = 3 and mode = 4, you can indicate (set 'y' to overwrite) that you want to overwrite the given instance");
            System.out.println();
            System.out.println("Exit code of instanceChecker (with usage 2) is as follows:");
            System.out.println("  0 : no problem occurs and the instance is valid");
            System.out.println("  1 : the instance is not valid");
            System.out.println("  2 : a problem occurs (file not found, ...)");
            System.exit(0);
        }
    }

    class MyPanel
    extends JPanel {
        private static final long serialVersionUID = 1L;
        JTextField srcField = new JTextField(20);
        JTextField dstField = new JTextField(20);
        JButton srcButton = new JButton("Src");
        JButton dstButton = new JButton("Dst");
        JRadioButton validation = new JRadioButton("check validity of instances");
        JRadioButton validationPlus = new JRadioButton("check validity of instances (including additional rules of the 2008 competition of CSP solvers)");
        JRadioButton convert = new JRadioButton("check (not including additional 2008 competition rules) and convert instances into canonical form");
        JRadioButton toExtension = new JRadioButton("check (not including additional 2008 competition rules) and convert instances into canonical extensional form");
        ButtonGroup group = new ButtonGroup();
        JCheckBox defaultBox = new JCheckBox("Default file names");
        JButton startButton = new JButton("Start");
        JButton stopButton = new JButton("Stop");
        JTextArea textArea = new JTextArea(18, 50);
        JScrollPane scrollPane = new JScrollPane(this.textArea);
        JTextField counter1Field = new JTextField("0", 3);
        JTextField counter2Field = new JTextField("0", 3);
        JTextField counter3Field = new JTextField("0", 3);
        File srcDirectory;
        File dstDirectory;

        private void manageStartButton() {
            this.startButton.setEnabled(this.srcDirectory != null && (this.validation.isSelected() || this.validationPlus.isSelected() || this.dstDirectory != null));
        }

        MyPanel() {
            JPanel p1 = new JPanel();
            p1.add(this.srcButton);
            p1.add(this.srcField);
            this.srcField.setEnabled(false);
            this.srcField.setToolTipText("The source directory, if selected, is displayed in this field");
            this.srcButton.setToolTipText("Push this button in order to select the source directory, i.e. the directory which contains files that represent CSP instances.");
            JPanel p2 = new JPanel();
            p2.add(this.dstButton);
            p2.add(this.dstField);
            this.dstField.setToolTipText("The destination directory, if selected, is displayed in this field");
            this.dstButton.setToolTipText("Push this button in order to select the destination directory, i.e. the directory which must contain files to be generated.");
            this.dstField.setEnabled(false);
            JPanel p2b = new JPanel();
            p2b.setLayout(new GridLayout(4, 2, 5, 5));
            p2b.add(this.validation);
            this.validation.setToolTipText("Select this radio button in order to check files, with suffix xml, that are located in the source directory.");
            p2b.add(this.validationPlus);
            this.validationPlus.setToolTipText("Select this radio button in order to check files, with suffix xml, that are located in the source directory.");
            p2b.add(this.convert);
            this.convert.setToolTipText("Select this radio button in order to convert instances into canonical form.");
            p2b.add(this.toExtension);
            this.toExtension.setToolTipText("Select this radio button in order to convert instances into extensional form.");
            JPanel p2t = new JPanel();
            p2t.setLayout(new BoxLayout(p2t, 0));
            p2t.add(Box.createHorizontalGlue());
            p2t.add(p2b);
            p2t.add(Box.createHorizontalGlue());
            this.group.add(this.validation);
            this.group.add(this.validationPlus);
            this.group.add(this.convert);
            this.group.add(this.toExtension);
            this.validation.setSelected(true);
            TitledBorder line = BorderFactory.createTitledBorder("Mode");
            EmptyBorder empty = new EmptyBorder(10, 10, 10, 10);
            p2b.setBorder(BorderFactory.createCompoundBorder(empty, line));
            JPanel p3 = new JPanel();
            p3.add(this.defaultBox);
            this.defaultBox.setToolTipText("Select this box in order to generate files with a default file name as a prefix.");
            p3.add(new JLabel("    "));
            JPanel p4 = new JPanel();
            p4.add(this.startButton);
            this.startButton.setEnabled(false);
            this.startButton.setToolTipText("Push this button in order to start checking (and generation).");
            p4.add(this.stopButton);
            this.stopButton.setEnabled(false);
            this.stopButton.setToolTipText("Push this button in order to stop checking (and generation).");
            JPanel p5 = new JPanel();
            this.textArea.setEditable(false);
            this.textArea.setFont(new Font("Serif", 0, 12));
            p5.add(this.scrollPane);
            this.textArea.setToolTipText("Area that gives information about checking and generation");
            JPanel p6 = new JPanel();
            p6.setLayout(new BoxLayout(p6, 0));
            p6.add(Box.createHorizontalGlue());
            p6.add(Box.createRigidArea(new Dimension(5, 0)));
            p6.add(new JLabel("Valid / Invalid / Ignored "));
            p6.add(Box.createRigidArea(new Dimension(5, 0)));
            p6.add(this.counter1Field);
            this.counter1Field.setToolTipText("Counter that gives the number of files that have been succesfully checked");
            this.counter1Field.setMaximumSize(new Dimension(15, 25));
            p6.add(Box.createRigidArea(new Dimension(5, 0)));
            p6.add(this.counter2Field);
            this.counter2Field.setToolTipText("Counter that gives the number of files that have been unsuccesfully checked");
            this.counter2Field.setMaximumSize(new Dimension(15, 25));
            p6.add(Box.createRigidArea(new Dimension(5, 0)));
            p6.add(this.counter3Field);
            this.counter3Field.setToolTipText("Counter that gives the number of files that have been ignored (suffix different from xml)");
            this.counter3Field.setMaximumSize(new Dimension(15, 25));
            p6.add(Box.createRigidArea(new Dimension(5, 0)));
            p6.add(Box.createHorizontalGlue());
            this.setLayout(new BoxLayout(this, 1));
            this.add(Box.createRigidArea(new Dimension(0, 10)));
            this.add(p1);
            this.add(Box.createRigidArea(new Dimension(0, 5)));
            this.add(p2);
            this.add(Box.createRigidArea(new Dimension(0, 10)));
            this.add(p2t);
            this.add(Box.createRigidArea(new Dimension(0, 10)));
            this.add(p3);
            this.add(Box.createRigidArea(new Dimension(0, 10)));
            this.add(p4);
            this.add(Box.createRigidArea(new Dimension(0, 10)));
            this.add(p5);
            this.add(Box.createRigidArea(new Dimension(0, 5)));
            this.add(p6);
            this.add(Box.createRigidArea(new Dimension(0, 10)));
            this.validation.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    if (MyPanel.this.validation.isSelected()) {
                        MyPanel.this.defaultBox.setEnabled(false);
                        MyPanel.this.defaultBox.setSelected(false);
                        MyPanel.this.dstButton.setEnabled(false);
                        MyPanel.this.dstField.setText("");
                        MyPanel.this.dstDirectory = null;
                        MyPanel.this.manageStartButton();
                    } else if (!MyPanel.this.validationPlus.isSelected()) {
                        MyPanel.this.defaultBox.setEnabled(true);
                        MyPanel.this.dstButton.setEnabled(true);
                        MyPanel.this.manageStartButton();
                    }
                }
            });
            this.validationPlus.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    if (MyPanel.this.validationPlus.isSelected()) {
                        MyPanel.this.defaultBox.setEnabled(false);
                        MyPanel.this.defaultBox.setSelected(false);
                        MyPanel.this.dstButton.setEnabled(false);
                        MyPanel.this.dstField.setText("");
                        MyPanel.this.dstDirectory = null;
                        MyPanel.this.manageStartButton();
                    } else if (!MyPanel.this.validation.isSelected()) {
                        MyPanel.this.defaultBox.setEnabled(true);
                        MyPanel.this.dstButton.setEnabled(true);
                        MyPanel.this.manageStartButton();
                    }
                }
            });
            this.srcButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    JFileChooser chooser = new JFileChooser();
                    chooser.setFileSelectionMode(1);
                    if (chooser.showOpenDialog(InstanceChecker.this) == 0) {
                        File f = chooser.getSelectedFile();
                        if (!f.exists()) {
                            MyPanel.this.srcDirectory = null;
                            JOptionPane.showMessageDialog(InstanceChecker.this, "directory not found");
                        } else if (f.equals(MyPanel.this.dstDirectory) && MyPanel.this.defaultBox.isSelected()) {
                            JOptionPane.showMessageDialog(null, "Please, with default file names, select a source directory different from the destination directory.");
                        } else {
                            MyPanel.this.srcDirectory = f;
                            MyPanel.this.srcField.setText(chooser.getSelectedFile().getPath());
                        }
                        MyPanel.this.manageStartButton();
                    }
                }
            });
            this.dstButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    JFileChooser chooser = new JFileChooser();
                    chooser.setFileSelectionMode(1);
                    if (chooser.showOpenDialog(InstanceChecker.this) == 0) {
                        File f = chooser.getSelectedFile();
                        if (f.equals(MyPanel.this.srcDirectory) && MyPanel.this.defaultBox.isSelected()) {
                            JOptionPane.showMessageDialog(null, "Please, with default file names, select a destination directory different from the source directory.");
                        } else {
                            MyPanel.this.dstDirectory = f;
                            MyPanel.this.dstField.setText(chooser.getSelectedFile().getPath());
                        }
                    }
                    MyPanel.this.manageStartButton();
                }
            });
            this.startButton.addActionListener(new ActionListener(){

                private CHECKING_MODE getMode() {
                    if (MyPanel.this.validation.isSelected() || MyPanel.this.validationPlus.isSelected()) {
                        return CHECKING_MODE.VALIDATION;
                    }
                    if (MyPanel.this.convert.isSelected()) {
                        return CHECKING_MODE.CANONICAL;
                    }
                    return CHECKING_MODE.EXTENSIONAL;
                }

                @Override
                public void actionPerformed(ActionEvent e) {
                    MyPanel.this.startButton.setEnabled(false);
                    MyPanel.this.textArea.setText("");
                    InstanceChecker.this.updateCounters(0, 0, 0);
                    InstanceChecker.this.coder = new InstanceCheckerEngine(InstanceChecker.this, InstanceChecker.this.indicator, MyPanel.this.srcDirectory, MyPanel.this.dstDirectory, MyPanel.this.defaultBox.isSelected(), MyPanel.this.validationPlus.isSelected(), this.getMode());
                    InstanceChecker.this.coder.start();
                    MyPanel.this.stopButton.setEnabled(true);
                }
            });
            this.stopButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (InstanceChecker.this.coder == null) {
                        return;
                    }
                    InstanceChecker.this.coder.setFinished(true);
                    MyPanel.this.stopButton.setEnabled(false);
                }
            });
        }
    }

    static enum CHECKING_MODE {
        VALIDATION,
        CANONICAL,
        EXTENSIONAL;


        public static CHECKING_MODE getOperatorFor(int mode) {
            if (mode == 1 || mode == 2) {
                return VALIDATION;
            }
            if (mode == 3) {
                return CANONICAL;
            }
            if (mode == 4) {
                return EXTENSIONAL;
            }
            System.out.println("ERROR \t the mode is not correct");
            System.exit(1);
            return null;
        }
    }

    static class IndicatorGUI
    implements Indicator {
        MyPanel content;

        public IndicatorGUI(MyPanel content) {
            this.content = content;
        }

        @Override
        public void write(String text) {
            this.content.textArea.append(text);
            this.content.textArea.setAutoscrolls(true);
            JScrollBar scrollBar = this.content.scrollPane.getVerticalScrollBar();
            scrollBar.setValue(scrollBar.getMaximum());
        }
    }

    public static interface Indicator {
        public void write(String var1);
    }
}

