/*
 * Decompiled with CFR 0.152.
 */
package parser.absconparseur.tools;

import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import java.util.StringTokenizer;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import parser.absconparseur.InstanceTokens;
import parser.absconparseur.XMLManager;

public class DocumentShuffler {
    Map<String, String> variableNamesMap = new HashMap<String, String>();

    private String changeNames(String s, Map<String, String> map) {
        StringBuffer sb = new StringBuffer();
        StringTokenizer st = new StringTokenizer(s);
        String name = st.nextToken();
        sb.append(map.get(name));
        while (st.hasMoreTokens()) {
            name = st.nextToken();
            sb.append(" " + map.get(name));
        }
        return sb.toString();
    }

    private int[] buildPermutation(Random random, int size) {
        int[] values = new int[size];
        for (int i = 0; i < values.length; ++i) {
            values[i] = i;
        }
        int nbValues = values.length;
        int[] t = new int[size];
        for (int i = 0; i < size; ++i) {
            int j = random.nextInt(size - i);
            t[i] = values[j];
            values[j] = values[size - i - 1];
            --nbValues;
        }
        return t;
    }

    private Map<String, String> modifyOrder(Random random, Element parent, NodeList nodeList, boolean variables, int mode) {
        int i;
        HashMap<String, String> variablesMap = new HashMap<String, String>();
        int[] permutation = this.buildPermutation(random, nodeList.getLength());
        Element[] elements = new Element[nodeList.getLength()];
        for (i = 0; i < nodeList.getLength(); ++i) {
            Element element = (Element)nodeList.item(i);
            String name = element.getAttribute("name");
            String canonicalName = null;
            canonicalName = variables ? (mode == 2 ? name : InstanceTokens.getVariableNameFor(permutation[i])) : (mode == 1 ? name : InstanceTokens.getConstraintNameFor(permutation[i]));
            element.setAttribute("name", canonicalName);
            variablesMap.put(name, canonicalName);
            if (variables) {
                elements[mode == 2 ? i : permutation[i]] = element;
                continue;
            }
            elements[mode == 1 ? i : permutation[i]] = element;
        }
        for (i = 0; i < nodeList.getLength(); ++i) {
            parent.removeChild(nodeList.item(i));
        }
        for (i = 0; i < elements.length; ++i) {
            parent.appendChild(elements[i]);
        }
        return variablesMap;
    }

    public Document shuffle(Document document, int seed, int mode) {
        Random random = new Random(seed);
        Element variablesElement = XMLManager.getFirstElementByTagNameFromRoot(document, "variables");
        NodeList nodeList = variablesElement.getElementsByTagName("variable");
        Map<String, String> variablesMap = this.modifyOrder(random, variablesElement, nodeList, true, mode);
        Element constraintsElement = XMLManager.getFirstElementByTagNameFromRoot(document, "constraints");
        nodeList = constraintsElement.getElementsByTagName("constraint");
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Element element = (Element)nodeList.item(i);
            String canonicalName = InstanceTokens.getConstraintNameFor(i);
            element.setAttribute("name", canonicalName);
            String scope = element.getAttribute("scope");
            element.setAttribute("scope", this.changeNames(scope, variablesMap));
            Element parameters = XMLManager.getElementByTagNameFrom(element, "parameters", 0);
            if (parameters == null) continue;
            String canonicalExpression = "";
            StringTokenizer st = new StringTokenizer(parameters.getTextContent());
            while (st.hasMoreTokens()) {
                String token = st.nextToken();
                if (variablesMap.containsKey(token)) {
                    canonicalExpression = canonicalExpression + " " + variablesMap.get(token);
                    continue;
                }
                canonicalExpression = canonicalExpression + " " + token;
            }
            parameters.setTextContent(canonicalExpression.trim());
        }
        this.modifyOrder(random, constraintsElement, nodeList, false, mode);
        return document;
    }
}

