/*
 * Decompiled with CFR 0.152.
 */
package parser.absconparseur.tools;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import parser.absconparseur.InstanceTokens;
import parser.absconparseur.XMLManager;
import parser.absconparseur.components.PRelation;
import parser.absconparseur.intension.PredicateManager;
import parser.absconparseur.tools.InstanceCheckerEngine;
import parser.absconparseur.tools.InstanceCheckerParser;

public class DocumentModifier {
    public static boolean isPresentChild(Document document, String tagName) {
        NodeList nodeList = document.getDocumentElement().getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            if (!nodeList.item(i).getNodeName().equals(tagName)) continue;
            return true;
        }
        return false;
    }

    public static boolean areOrderedChilds(Document document, String tagName1, String tagName2) {
        NodeList nodeList = document.getDocumentElement().getChildNodes();
        int i = 0;
        for (i = 0; i < nodeList.getLength() && !nodeList.item(i).getNodeName().equals(tagName1); ++i) {
        }
        if (i >= nodeList.getLength()) {
            return false;
        }
        ++i;
        while (i < nodeList.getLength()) {
            if (nodeList.item(i).getNodeName().equals(tagName2)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public Document modifyDocumentFrom(InstanceCheckerEngine logic, Document document, InstanceCheckerParser problem) {
        Element predicatesElement = XMLManager.getElementByTagNameFrom(document.getDocumentElement(), "predicates", 0);
        if (predicatesElement != null) {
            document.getDocumentElement().removeChild(predicatesElement);
        }
        Element constraintsElement = XMLManager.getElementByTagNameFrom(document.getDocumentElement(), "constraints", 0);
        NodeList nodeList = constraintsElement.getElementsByTagName("constraint");
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Element element = (Element)nodeList.item(i);
            String reference = element.getAttribute("reference");
            if (!problem.getPredicatesMap().containsKey(reference)) continue;
            Element parameters = XMLManager.getElementByTagNameFrom(element, "parameters", 0);
            element.removeChild(parameters);
            String name = element.getAttribute("name");
            element.setAttribute("reference", problem.getConstraintsToNewRelations().get(name));
        }
        Element relationsElement = XMLManager.getElementByTagNameFrom(document.getDocumentElement(), "relations", 0);
        if (relationsElement == null) {
            relationsElement = document.createElement("relations");
            document.getDocumentElement().insertBefore(relationsElement, constraintsElement);
        }
        relationsElement.setAttribute("nbRelations", problem.getRelationsMap().size() + problem.getNewRelations().size() + "");
        int cpt = 0;
        for (PRelation relation : problem.getNewRelations()) {
            ++cpt;
            Element relationElement = document.createElement("relation");
            relationElement.setAttribute("name", relation.getName());
            relationElement.setAttribute("arity", relation.getArity() + "");
            relationElement.setAttribute("nbTuples", relation.getTuples().length + "");
            relationElement.setAttribute("semantics", relation.getSemantics());
            relationElement.setTextContent(relation.getStringListOfTuples());
            relationsElement.appendChild(relationElement);
            if (cpt % 10 != 0) continue;
            logic.spot();
        }
        return document;
    }

    private String changeToCanonicalNames(String s, Map<String, String> map) {
        StringBuffer sb = new StringBuffer();
        StringTokenizer st = new StringTokenizer(s);
        do {
            String name;
            String newName;
            if ((newName = map.get(name = st.nextToken())) == null) {
                sb.append(name);
            } else {
                sb.append(newName);
            }
            if (!st.hasMoreTokens()) continue;
            sb.append(" ");
        } while (st.hasMoreTokens());
        return sb.toString();
    }

    public Document setCanonicalFormOf(InstanceCheckerEngine logic, Document document, boolean canonicalNames) {
        String canonicalName;
        String name;
        Element element;
        Element presentationElement = XMLManager.getFirstElementByTagNameFromRoot(document, "presentation");
        presentationElement.setAttribute("name", "?");
        presentationElement.removeAttribute("nbSolutions");
        presentationElement.removeAttribute("solution");
        presentationElement.setTextContent("");
        presentationElement.setAttribute("format", "XCSP 2.0");
        logic.spot();
        if (canonicalNames) {
            return document;
        }
        HashMap<String, String> domainsMap = new HashMap<String, String>();
        NodeList nodeList = XMLManager.getFirstElementByTagNameFromRoot(document, "domains").getElementsByTagName("domain");
        for (int i = 0; i < nodeList.getLength(); ++i) {
            String canonicalName2;
            Element element2 = (Element)nodeList.item(i);
            String name2 = element2.getAttribute("name");
            if (name2.equals(canonicalName2 = InstanceTokens.getDomainNameFor(i))) continue;
            element2.setAttribute("name", canonicalName2);
            domainsMap.put(name2, canonicalName2);
        }
        logic.spot();
        HashMap<String, String> variablesMap = new HashMap<String, String>();
        nodeList = XMLManager.getFirstElementByTagNameFromRoot(document, "variables").getElementsByTagName("variable");
        for (int i = 0; i < nodeList.getLength(); ++i) {
            String domainName;
            String canonicalDomainName;
            String canonicalName3;
            Element element3 = (Element)nodeList.item(i);
            String name3 = element3.getAttribute("name");
            if (!name3.equals(canonicalName3 = InstanceTokens.getVariableNameFor(i))) {
                element3.setAttribute("name", canonicalName3);
                variablesMap.put(name3, canonicalName3);
            }
            if (domainsMap.size() == 0 || (canonicalDomainName = (String)domainsMap.get(domainName = element3.getAttribute("domain"))) == null) continue;
            element3.setAttribute("domain", canonicalDomainName);
        }
        logic.spot();
        HashMap<String, String> relationsMap = new HashMap<String, String>();
        Element rels = XMLManager.getFirstElementByTagNameFromRoot(document, "relations");
        if (rels != null) {
            nodeList = rels.getElementsByTagName("relation");
            for (int i = 0; i < nodeList.getLength(); ++i) {
                String canonicalName4;
                Element element4 = (Element)nodeList.item(i);
                String name4 = element4.getAttribute("name");
                if (!name4.equals(canonicalName4 = InstanceTokens.getRelationNameFor(i))) {
                    element4.setAttribute("name", canonicalName4);
                }
                relationsMap.put(name4, canonicalName4);
            }
        }
        logic.spot();
        HashMap<String, String> predicatesMap = new HashMap<String, String>();
        Element preds = XMLManager.getFirstElementByTagNameFromRoot(document, "predicates");
        if (preds != null) {
            nodeList = preds.getElementsByTagName("predicate");
            for (int i = 0; i < nodeList.getLength(); ++i) {
                element = (Element)nodeList.item(i);
                name = element.getAttribute("name");
                if (!name.equals(canonicalName = InstanceTokens.getPredicateNameFor(i))) {
                    element.setAttribute("name", canonicalName);
                }
                predicatesMap.put(name, canonicalName);
                Element parameters = XMLManager.getElementByTagNameFrom(element, "parameters", 0);
                Element expression = XMLManager.getElementByTagNameFrom(element, "expression", 0);
                Element functional = XMLManager.getElementByTagNameFrom(expression, "functional", 0);
                HashMap<String, String> parametersMap = new HashMap<String, String>();
                String oldFormalParameters = parameters.getTextContent();
                String newFormalParameters = "";
                ArrayList<String> formalParameters = new ArrayList<String>();
                StringTokenizer st = new StringTokenizer(oldFormalParameters);
                int cpt = 0;
                while (st.hasMoreTokens()) {
                    newFormalParameters = newFormalParameters + " " + st.nextToken();
                    String oldParameter = st.nextToken();
                    String newParameter = InstanceTokens.getParameterNameFor(cpt++);
                    parametersMap.put(oldParameter, newParameter);
                    formalParameters.add(oldParameter);
                    newFormalParameters = newFormalParameters + " " + newParameter;
                }
                parameters.setTextContent(newFormalParameters.trim());
                String[] t = PredicateManager.buildUniversalPostfixExpression(functional.getTextContent().trim(), formalParameters.toArray(new String[formalParameters.size()]));
                String s2 = PredicateManager.buildFunctionalExpression(t);
                functional.setTextContent(s2.trim());
            }
        }
        logic.spot();
        nodeList = XMLManager.getFirstElementByTagNameFromRoot(document, "constraints").getElementsByTagName("constraint");
        for (int i = 0; i < nodeList.getLength(); ++i) {
            String reference;
            element = (Element)nodeList.item(i);
            name = element.getAttribute("name");
            if (!name.equals(canonicalName = InstanceTokens.getConstraintNameFor(i))) {
                element.setAttribute("name", canonicalName);
            }
            if (variablesMap.size() > 0) {
                String scope = element.getAttribute("scope");
                element.setAttribute("scope", this.changeToCanonicalNames(scope, variablesMap));
            }
            if (relationsMap.containsKey(reference = element.getAttribute("reference"))) {
                element.setAttribute("reference", (String)relationsMap.get(reference));
                continue;
            }
            if (!predicatesMap.containsKey(reference)) continue;
            element.setAttribute("reference", (String)predicatesMap.get(reference));
            if (variablesMap.size() <= 0) continue;
            Element parameters = XMLManager.getElementByTagNameFrom(element, "parameters", 0);
            String canonicalExpression = "";
            StringTokenizer st = new StringTokenizer(parameters.getTextContent());
            while (st.hasMoreTokens()) {
                String token = st.nextToken();
                String newToken = (String)variablesMap.get(token);
                if (newToken != null) {
                    canonicalExpression = canonicalExpression + " " + newToken;
                    continue;
                }
                canonicalExpression = canonicalExpression + " " + token;
            }
            parameters.setTextContent(canonicalExpression.trim());
        }
        logic.spot();
        return document;
    }
}

