/*
 * Decompiled with CFR 0.152.
 */
package parser.absconparseur.intension;

import java.util.Stack;
import java.util.StringTokenizer;
import parser.absconparseur.InstanceTokens;
import parser.absconparseur.Toolkit;
import parser.absconparseur.intension.Evaluator;

public class PredicateManager {
    private static String buildFunctionalToken(String token, Stack<String> stack) {
        if (Toolkit.isInteger(token)) {
            return token;
        }
        if (token.startsWith("X")) {
            return token;
        }
        int arity = Evaluator.getArityOf(token);
        if (arity == 0) {
            return token;
        }
        String s = token + "(" + stack.pop();
        for (int i = 1; i < arity; ++i) {
            s = s + "," + stack.pop();
        }
        return s + ")";
    }

    public static String buildFunctionalExpression(String[] postfixExpression) {
        Stack<String> stack = new Stack<String>();
        for (int i = 0; i < postfixExpression.length; ++i) {
            stack.add(PredicateManager.buildFunctionalToken(postfixExpression[i], stack));
        }
        assert (stack.size() == 1);
        return (String)stack.pop();
    }

    public static String buildFunctionalExpression(String postfixExpression) {
        Stack<String> stack = new Stack<String>();
        StringTokenizer st = new StringTokenizer(postfixExpression);
        while (st.hasMoreTokens()) {
            stack.add(PredicateManager.buildFunctionalToken(st.nextToken(), stack));
        }
        assert (stack.size() == 1);
        return (String)stack.pop();
    }

    public static String[] extractFormalParameters(String formalParametersExpression, boolean controlRedundancy) {
        StringTokenizer st = new StringTokenizer(formalParametersExpression);
        int cpt = 0;
        String[] formalParameters = new String[st.countTokens() / 2];
        while (st.hasMoreTokens()) {
            st.nextToken();
            String token = st.nextToken();
            if (controlRedundancy) {
                for (int j = 0; j < cpt; ++j) {
                    if (!formalParameters[j].equals(token)) continue;
                    return null;
                }
            }
            formalParameters[cpt++] = token;
        }
        return formalParameters;
    }

    public static String[] extractFormalParameters(String formalParametersExpression) {
        return PredicateManager.extractFormalParameters(formalParametersExpression, false);
    }

    public static String[] extractUniversalEffectiveParameters(String effectiveParametersExpression, String[] variableNames) {
        StringTokenizer st = new StringTokenizer(effectiveParametersExpression);
        String[] effectiveParameters = new String[st.countTokens()];
        for (int i = 0; i < effectiveParameters.length; ++i) {
            String token = st.nextToken();
            if (!Toolkit.isInteger(token)) {
                int position = Toolkit.searchIn(token, variableNames);
                if (position == -1) {
                    throw new IllegalArgumentException();
                }
                token = InstanceTokens.getParameterNameFor(position);
            }
            effectiveParameters[i] = token;
        }
        return effectiveParameters;
    }

    public static String buildUniversalPostfixExpression(StringTokenizer st, String[] formalParameters, boolean[] found) {
        String token = st.nextToken();
        if (Toolkit.isInteger(token)) {
            return token;
        }
        int position = Toolkit.searchIn(token, formalParameters);
        if (position != -1) {
            found[position] = true;
            return InstanceTokens.getParameterNameFor(position);
        }
        String s = token;
        int arity = Evaluator.getArityOf(token);
        for (int i = 0; i < arity; ++i) {
            s = PredicateManager.buildUniversalPostfixExpression(st, formalParameters, found) + " " + s;
        }
        return s;
    }

    public static String[] buildUniversalPostfixExpression(String functionalExpression, String[] formalParameters) {
        StringTokenizer st = new StringTokenizer(functionalExpression, " \t\n\r\f(),");
        boolean[] found = new boolean[formalParameters.length];
        String postfixExpression = PredicateManager.buildUniversalPostfixExpression(st, formalParameters, found);
        for (int i = 0; i < found.length; ++i) {
            if (found[i]) continue;
            throw new IllegalArgumentException("One formal parameter not found in the given expression");
        }
        st = new StringTokenizer(postfixExpression);
        String[] tokens = new String[st.countTokens()];
        for (int i = 0; i < tokens.length; ++i) {
            tokens[i] = st.nextToken();
        }
        return tokens;
    }

    public static String[] buildUniversalPostfixExpression(String functionalExpression, String formalParametersExpression) {
        return PredicateManager.buildUniversalPostfixExpression(functionalExpression, PredicateManager.extractFormalParameters(formalParametersExpression));
    }

    private static String[] buildNewUniversalPostfixExpression(String[] universalPostfixExpression, String[] universalEffectiveParameters) {
        String[] tokens = new String[universalPostfixExpression.length];
        for (int i = 0; i < tokens.length; ++i) {
            String token = universalPostfixExpression[i];
            tokens[i] = token.startsWith("X") ? universalEffectiveParameters[Integer.parseInt(token.substring("X".length()))] : token;
        }
        return tokens;
    }

    public static String[] buildNewUniversalPostfixExpression(String[] universalPostfixExpression, String effectiveParametersExpression, String[] variableNames) {
        return PredicateManager.buildNewUniversalPostfixExpression(universalPostfixExpression, PredicateManager.extractUniversalEffectiveParameters(effectiveParametersExpression, variableNames));
    }

    public static void modifyPredicateOrder(int[] permutation, String[] predicate) {
        for (int i = 0; i < predicate.length; ++i) {
            String token = predicate[i];
            if (!token.startsWith("X")) continue;
            int id = Integer.parseInt(token.substring("X".length()));
            predicate[i] = InstanceTokens.getParameterNameFor(permutation[id]);
        }
    }
}

