/*
 * Decompiled with CFR 0.152.
 */
package parser.absconparseur.intension;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import parser.absconparseur.ReflectionManager;
import parser.absconparseur.Toolkit;
import parser.absconparseur.intension.types.Arity0Type;
import parser.absconparseur.intension.types.Arity1Type;
import parser.absconparseur.intension.types.Arity2Type;
import parser.absconparseur.intension.types.Arity3Type;
import parser.absconparseur.intension.types.Arity4Type;
import parser.absconparseur.intension.types.AssociativeType;
import parser.absconparseur.intension.types.SymmetricType;

public abstract class Evaluator {
    private static Map<String, Class> classMap;
    private static Map<String, Integer> arityMap;
    private static Set<String> symmetricSet;
    private static Set<String> associativeSet;
    protected static int top;
    protected static long[] stack;

    public static Class getClassOf(String evaluatorToken) {
        return classMap.get(evaluatorToken);
    }

    public static int getArityOf(String evaluatorToken) {
        Integer i = arityMap.get(evaluatorToken);
        return i == null ? -1 : i;
    }

    public static boolean isSymmetric(String evaluatorToken) {
        return symmetricSet.contains(evaluatorToken);
    }

    public static boolean isAssociative(String evaluatorToken) {
        return associativeSet.contains(evaluatorToken);
    }

    public int getArity() {
        String className = Toolkit.getRelativeClassNameOf(this.getClass());
        String evaluatorToken = className.substring(0, 1).toLowerCase() + className.substring(1, className.lastIndexOf("Evaluator"));
        return arityMap.get(evaluatorToken);
    }

    public static int getTop() {
        return top;
    }

    public static void resetTop() {
        top = -1;
    }

    public static long getTopValue() {
        return stack[top];
    }

    public static void checkStackSize(int size) {
        if (stack.length < size) {
            stack = new long[size];
        }
    }

    public static void displayStack() {
        String s = "";
        for (int i = 0; i <= top; ++i) {
            s = s + stack[i] + " ";
        }
        System.out.println(s);
    }

    public abstract void evaluate();

    public String toString() {
        return Toolkit.getRelativeClassNameOf(this);
    }

    static {
        Class[] classes;
        classMap = new HashMap<String, Class>();
        arityMap = new HashMap<String, Integer>();
        symmetricSet = new HashSet<String>();
        associativeSet = new HashSet<String>();
        for (Class clazz : classes = ReflectionManager.searchClassesInheritingFrom(Evaluator.class, 1, 1024)) {
            String className = Toolkit.getRelativeClassNameOf(clazz);
            String evaluatorToken = className.substring(0, 1).toLowerCase() + className.substring(1, className.lastIndexOf("Evaluator"));
            classMap.put(evaluatorToken, clazz);
            int arity = -1;
            try {
                if (Arity0Type.class.isAssignableFrom(clazz)) {
                    arity = 0;
                }
                if (Arity1Type.class.isAssignableFrom(clazz)) {
                    arity = 1;
                }
                if (Arity2Type.class.isAssignableFrom(clazz)) {
                    arity = 2;
                }
                if (Arity3Type.class.isAssignableFrom(clazz)) {
                    arity = 3;
                }
                if (Arity4Type.class.isAssignableFrom(clazz)) {
                    arity = 4;
                }
                if (SymmetricType.class.isAssignableFrom(clazz)) {
                    symmetricSet.add(evaluatorToken);
                }
                if (AssociativeType.class.isAssignableFrom(clazz)) {
                    associativeSet.add(evaluatorToken);
                }
            }
            catch (Exception e) {
                System.out.println(e);
                System.exit(1);
            }
            arityMap.put(evaluatorToken, arity);
        }
        top = -1;
        stack = new long[100];
    }
}

