/*
 * Decompiled with CFR 0.152.
 */
package parser.absconparseur.intension;

import parser.absconparseur.ReflectionManager;
import parser.absconparseur.Toolkit;
import parser.absconparseur.components.PVariable;
import parser.absconparseur.intension.Evaluator;
import parser.absconparseur.intension.arithmetic.AbsEvaluator;
import parser.absconparseur.intension.arithmetic.AddEvaluator;
import parser.absconparseur.intension.arithmetic.ArithmeticEvaluator;
import parser.absconparseur.intension.arithmetic.DivEvaluator;
import parser.absconparseur.intension.arithmetic.IfEvaluator;
import parser.absconparseur.intension.arithmetic.MaxEvaluator;
import parser.absconparseur.intension.arithmetic.MinEvaluator;
import parser.absconparseur.intension.arithmetic.ModEvaluator;
import parser.absconparseur.intension.arithmetic.MulEvaluator;
import parser.absconparseur.intension.arithmetic.NegEvaluator;
import parser.absconparseur.intension.arithmetic.PowEvaluator;
import parser.absconparseur.intension.arithmetic.SubEvaluator;
import parser.absconparseur.intension.logical.AndEvaluator;
import parser.absconparseur.intension.logical.LogicalEvaluator;
import parser.absconparseur.intension.logical.NotEvaluator;
import parser.absconparseur.intension.logical.OrEvaluator;
import parser.absconparseur.intension.relational.RelationalEvaluator;
import parser.absconparseur.intension.terminal.FalseEvaluator;
import parser.absconparseur.intension.terminal.LongEvaluator;
import parser.absconparseur.intension.terminal.TrueEvaluator;
import parser.absconparseur.intension.terminal.VariableEvaluator;
import parser.absconparseur.intension.types.BooleanType;
import parser.absconparseur.intension.types.IntegerType;

public class EvaluationManager {
    protected String[] universalPostfixExpression;
    protected Evaluator[] evaluators;
    protected int[] shortCircuits;
    protected int[] currentValues;

    public int getCurentValueOf(int variablePosition) {
        return this.currentValues[variablePosition];
    }

    private Evaluator buildEvaluator(String token) {
        Long l = Toolkit.parseLong(token);
        if (l != null) {
            return new LongEvaluator(l);
        }
        if (token.startsWith("X")) {
            return new VariableEvaluator(this, Integer.parseInt(token.substring("X".length())));
        }
        return (Evaluator)ReflectionManager.getInstanceOf(Evaluator.getClassOf(token));
    }

    private void buildEvaluatorsFrom(String[] canonicalPostfixExpression) {
        this.evaluators = new Evaluator[canonicalPostfixExpression.length];
        for (int i = 0; i < this.evaluators.length; ++i) {
            this.evaluators[i] = this.buildEvaluator(canonicalPostfixExpression[i]);
        }
    }

    protected void dealWithShortCircuits() {
        boolean useShortCircuits = true;
        if (!useShortCircuits) {
            return;
        }
        this.shortCircuits = new int[this.evaluators.length];
        useShortCircuits = false;
        for (int i = 0; i < this.evaluators.length - 1; ++i) {
            int j;
            if (this.evaluators[i] instanceof IntegerType) continue;
            int nbStackedElements = 1;
            for (j = i + 1; j < this.evaluators.length && (nbStackedElements += 1 - this.evaluators[j].getArity()) > 1; ++j) {
            }
            if (j == i + 1) continue;
            if (this.evaluators[j] instanceof OrEvaluator) {
                this.shortCircuits[i] = j + 1;
                useShortCircuits = true;
                continue;
            }
            if (!(this.evaluators[j] instanceof AndEvaluator)) continue;
            this.shortCircuits[i] = -j - 1;
            useShortCircuits = true;
        }
        if (!useShortCircuits) {
            this.shortCircuits = null;
        }
    }

    public EvaluationManager(String[] universalPostfixExpression) {
        this.universalPostfixExpression = universalPostfixExpression;
        this.buildEvaluatorsFrom(universalPostfixExpression);
        this.dealWithShortCircuits();
        Evaluator.checkStackSize(this.evaluators.length);
    }

    private int nextEvaluator(int i) {
        if (this.shortCircuits[i] > 0) {
            return Evaluator.getTopValue() == 1L ? this.shortCircuits[i] : i + 1;
        }
        return Evaluator.getTopValue() == 0L ? -this.shortCircuits[i] : i + 1;
    }

    public final boolean checkValues(int[] values) {
        this.currentValues = values;
        Evaluator.resetTop();
        if (this.shortCircuits == null) {
            for (Evaluator evaluator : this.evaluators) {
                evaluator.evaluate();
            }
        } else {
            int i = 0;
            while (i < this.evaluators.length) {
                this.evaluators[i].evaluate();
                i = this.shortCircuits[i] == 0 ? i + 1 : this.nextEvaluator(i);
            }
        }
        assert (Evaluator.getTop() == 0) : "" + Evaluator.getTop();
        return Evaluator.getTopValue() == 1L;
    }

    public boolean controlArityOfEvaluators() {
        int nbStackedElements = 0;
        for (int i = 0; i < this.evaluators.length; ++i) {
            nbStackedElements += 1 - this.evaluators[i].getArity();
        }
        return nbStackedElements == 1;
    }

    public boolean controlTypeOfEvaluators() {
        if (!(this.evaluators[this.evaluators.length - 1] instanceof BooleanType)) {
            return false;
        }
        boolean[] booleanTypes = new boolean[this.evaluators.length];
        int top = -1;
        for (Evaluator evaluator : this.evaluators) {
            int j;
            if (evaluator instanceof ArithmeticEvaluator) {
                if (evaluator instanceof IfEvaluator) {
                    if (!booleanTypes[top] || booleanTypes[top - 1] || booleanTypes[top - 2]) {
                        return false;
                    }
                    top -= 3;
                } else {
                    for (j = 0; j < evaluator.getArity(); ++j) {
                        if (booleanTypes[top]) {
                            return false;
                        }
                        --top;
                    }
                }
            } else if (evaluator instanceof LogicalEvaluator) {
                for (j = 0; j < evaluator.getArity(); ++j) {
                    if (!booleanTypes[top]) {
                        return false;
                    }
                    --top;
                }
            } else if (evaluator instanceof RelationalEvaluator) {
                for (j = 0; j < evaluator.getArity(); ++j) {
                    if (booleanTypes[top]) {
                        return false;
                    }
                    --top;
                }
            }
            booleanTypes[++top] = evaluator instanceof BooleanType;
        }
        return true;
    }

    public boolean isGuaranteedToBeDivisionByZeroFree(PVariable[] variables) {
        for (int i = 0; i < this.evaluators.length; ++i) {
            if (!(this.evaluators[i] instanceof DivEvaluator) && !(this.evaluators[i] instanceof ModEvaluator) || this.evaluators[i - 1] instanceof LongEvaluator && ((LongEvaluator)this.evaluators[i - 1]).getValue() != 0L || this.evaluators[i - 1] instanceof VariableEvaluator && !variables[((VariableEvaluator)this.evaluators[i - 1]).getPosition()].getDomain().contains(0)) continue;
            return false;
        }
        return true;
    }

    public boolean isGuaranteedToBeOverflowFree(PVariable[] variables) {
        int[] lstack = new int[this.evaluators.length];
        double[] dstack = new double[this.evaluators.length];
        int top = -1;
        for (int i = 0; i < this.evaluators.length; ++i) {
            Evaluator evaluator = this.evaluators[i];
            if (evaluator instanceof LongEvaluator) {
                lstack[++top] = (int)Math.abs(((LongEvaluator)evaluator).getValue());
                dstack[top] = Math.abs(((LongEvaluator)evaluator).getValue());
            } else if (evaluator instanceof VariableEvaluator) {
                int maxAbsoluteValue;
                int[] values = variables[((VariableEvaluator)evaluator).getPosition()].getDomain().getValues();
                lstack[++top] = maxAbsoluteValue = Math.max(Math.abs(values[0]), Math.abs(values[values.length - 1]));
                dstack[top] = maxAbsoluteValue;
            } else if (evaluator instanceof TrueEvaluator) {
                lstack[++top] = 1;
                dstack[top] = 1.0;
            } else if (evaluator instanceof FalseEvaluator) {
                lstack[++top] = 0;
                dstack[top] = 0.0;
            } else if (!(evaluator instanceof AbsEvaluator)) {
                if (evaluator instanceof AddEvaluator) {
                    lstack[--top] = lstack[top + 1] + lstack[top];
                    dstack[top] = dstack[top + 1] + dstack[top];
                } else if (evaluator instanceof DivEvaluator) {
                    --top;
                } else if (evaluator instanceof IfEvaluator) {
                    lstack[top -= 2] = Math.max(lstack[top + 1], lstack[top]);
                    dstack[top] = Math.max(dstack[top + 1], dstack[top]);
                } else if (evaluator instanceof MaxEvaluator) {
                    lstack[--top] = Math.max(lstack[top + 1], lstack[top]);
                    dstack[top] = Math.max(dstack[top + 1], dstack[top]);
                } else if (evaluator instanceof MinEvaluator) {
                    lstack[--top] = Math.min(lstack[top + 1], lstack[top]);
                    dstack[top] = Math.min(dstack[top + 1], dstack[top]);
                } else if (evaluator instanceof ModEvaluator) {
                    --top;
                } else if (evaluator instanceof MulEvaluator) {
                    lstack[--top] = lstack[top + 1] * lstack[top];
                    dstack[top] = dstack[top + 1] * dstack[top];
                } else if (!(evaluator instanceof NegEvaluator)) {
                    if (evaluator instanceof PowEvaluator) {
                        lstack[--top] = (int)Math.pow(lstack[top + 1], lstack[top]);
                        dstack[top] = Math.pow(dstack[top + 1], dstack[top]);
                    } else if (evaluator instanceof SubEvaluator) {
                        lstack[--top] = lstack[top + 1] + lstack[top];
                        dstack[top] = dstack[top + 1] + dstack[top];
                    } else if (evaluator instanceof NotEvaluator) {
                        lstack[top] = 1;
                        dstack[top] = 1.0;
                    } else if (evaluator instanceof LogicalEvaluator) {
                        lstack[--top] = 1;
                        dstack[top] = 1.0;
                    } else if (evaluator instanceof RelationalEvaluator) {
                        lstack[--top] = 1;
                        dstack[top] = 1.0;
                    } else {
                        throw new IllegalArgumentException();
                    }
                }
            }
            if ((double)lstack[top] == dstack[top] && !Double.isInfinite(dstack[top])) continue;
            return false;
        }
        return true;
    }

    public void display() {
        for (int i = 0; i < this.evaluators.length; ++i) {
            System.out.print(this.evaluators[i] + " ");
        }
        System.out.println();
    }
}

