/*
 * Decompiled with CFR 0.152.
 */
package parser.absconparseur.components;

import parser.absconparseur.PredicateTokens;
import parser.absconparseur.components.PGlobalConstraint;
import parser.absconparseur.components.PVariable;

public class PWeightedSum
extends PGlobalConstraint {
    private int[] coeffs;
    private PredicateTokens.RelationalOperator operator;
    private int limit;

    public int[] getCoeffs() {
        return this.coeffs;
    }

    public PredicateTokens.RelationalOperator getOperator() {
        return this.operator;
    }

    public PWeightedSum(String name, PVariable[] scope, int[] coeffs, PredicateTokens.RelationalOperator operator, int limit) {
        super(name, scope);
        this.coeffs = coeffs;
        this.operator = operator;
        this.limit = limit;
    }

    public int getLimit() {
        return this.limit;
    }

    @Override
    public int computeCostOf(int[] tuple) {
        int sum = 0;
        for (int i = 0; i < this.coeffs.length; ++i) {
            sum += this.coeffs[i] * tuple[i];
        }
        boolean satisfied = this.operator == PredicateTokens.RelationalOperator.EQ ? sum == this.limit : (this.operator == PredicateTokens.RelationalOperator.NE ? sum != this.limit : (this.operator == PredicateTokens.RelationalOperator.GE ? sum >= this.limit : (this.operator == PredicateTokens.RelationalOperator.GT ? sum > this.limit : (this.operator == PredicateTokens.RelationalOperator.LE ? sum <= this.limit : sum < this.limit))));
        return satisfied ? 0 : 1;
    }

    @Override
    public String toString() {
        String s = super.toString() + " : weightedSum\n\t";
        for (int i = 0; i < this.coeffs.length; ++i) {
            s = s + this.coeffs[i] + "*" + this.scope[i].getName() + " ";
        }
        s = s + PredicateTokens.RelationalOperator.getStringFor(this.operator) + " " + this.limit;
        return s;
    }

    @Override
    public boolean isGuaranteedToBeOverflowFree() {
        int sumL = 0;
        double sumD = 0.0;
        for (int i = 0; i < this.scope.length; ++i) {
            int[] values = this.scope[i].getDomain().getValues();
            int maxAbsoluteValue = Math.max(Math.abs(values[0]), Math.abs(values[values.length - 1]));
            sumL += Math.abs(this.coeffs[i]) * maxAbsoluteValue;
            sumD += (double)(Math.abs(this.coeffs[i]) * maxAbsoluteValue);
        }
        return (double)sumL == sumD && !Double.isInfinite(sumD);
    }
}

