/*
 * Decompiled with CFR 0.152.
 */
package parser.absconparseur.components;

import choco.kernel.model.constraints.automaton.DFA;
import choco.kernel.solver.constraints.integer.extension.BinRelation;
import choco.kernel.solver.constraints.integer.extension.LargeRelation;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import parser.absconparseur.Toolkit;
import parser.chocogen.XmlClause;

public class PRelation {
    private String name;
    private int arity;
    private int nbTuples;
    private String semantics;
    private int[][] tuples;
    private List<int[]> ltuples;
    private int index;
    private int[] weights;
    private int defaultCost;
    private int maximalCost;
    protected BinRelation brel;
    protected LargeRelation lrel;
    protected List<XmlClause> satencoding;
    protected DFA dfa;
    protected boolean eqInTuples;
    protected boolean neqInTuples;

    public String getName() {
        return this.name;
    }

    public int getArity() {
        return this.arity;
    }

    public int getNbTuples() {
        return this.nbTuples;
    }

    public String getSemantics() {
        return this.semantics;
    }

    public int[][] getTuples() {
        return this.tuples;
    }

    public BinRelation getBrel() {
        return this.brel;
    }

    public void setBrel(BinRelation brel) {
        this.brel = brel;
    }

    public LargeRelation getLrel() {
        return this.lrel;
    }

    public void setLrel(LargeRelation lrel) {
        this.lrel = lrel;
    }

    public DFA getDfa() {
        return this.dfa;
    }

    public void setDfa(DFA dfa) {
        this.dfa = dfa;
    }

    public void setClauseEncoding(List<XmlClause> encoding) {
        this.satencoding = encoding;
    }

    public List<XmlClause> getSatEncoding() {
        return this.satencoding;
    }

    public boolean isNeqInTuples() {
        return this.neqInTuples;
    }

    public void setNeqInTuples(boolean neqInTuples) {
        this.neqInTuples = neqInTuples;
    }

    public boolean isEqInTuples() {
        return this.eqInTuples;
    }

    public void setEqInTuples(boolean eqInTuples) {
        this.eqInTuples = eqInTuples;
    }

    public boolean checkEqInCouples() {
        for (int[] t : this.ltuples) {
            if (t[0] == t[1]) continue;
            return false;
        }
        return true;
    }

    public boolean checkNeqInCouples() {
        for (int[] t : this.ltuples) {
            if (t[0] != t[1]) continue;
            return false;
        }
        return true;
    }

    public List<int[]> getListTuples() {
        if (this.ltuples != null) {
            return this.ltuples;
        }
        this.ltuples = new LinkedList<int[]>();
        for (int i = 0; i < this.tuples.length; ++i) {
            this.ltuples.add(this.tuples[i]);
        }
        this.tuples = null;
        return this.ltuples;
    }

    public void eraseListTuple() {
        this.ltuples = null;
    }

    public int[] getWeights() {
        return this.weights;
    }

    public int getDefaultCost() {
        return this.defaultCost;
    }

    public int getMaximalCost() {
        return this.maximalCost;
    }

    public PRelation(String name, int arity, int nbTuples, String semantics, int[][] tuples, int[] weights, int defaultCost) {
        this.name = name;
        this.arity = arity;
        this.nbTuples = nbTuples;
        this.semantics = semantics;
        this.tuples = tuples;
        this.weights = weights;
        this.defaultCost = defaultCost;
        if (weights == null) {
            this.maximalCost = 1;
        } else {
            this.maximalCost = defaultCost;
            for (int w : weights) {
                if (w <= this.maximalCost) continue;
                this.maximalCost = w;
            }
        }
        this.index = Integer.parseInt(name.substring(1, name.length()));
    }

    public PRelation(String name, int arity, int nbTuples, String semantics, int[][] tuples) {
        this(name, arity, nbTuples, semantics, tuples, null, semantics.equals("supports") ? 1 : 0);
    }

    public int computeCostOf(int[] tuple) {
        int position = Arrays.binarySearch(this.tuples, tuple, Toolkit.lexicographicComparator);
        if (this.semantics.equals("soft")) {
            return position >= 0 ? this.weights[position] : this.defaultCost;
        }
        if (this.semantics.equals("supports")) {
            return position >= 0 ? 0 : 1;
        }
        return position >= 0 ? 1 : 0;
    }

    public String toString() {
        int displayLimit = 5;
        String s = "  relation " + this.name + " with arity=" + this.arity + ", semantics=" + this.semantics + ", nbTuples=" + this.nbTuples + ", defaultCost=" + this.defaultCost + " : ";
        for (int i = 0; i < Math.min(this.nbTuples, displayLimit); ++i) {
            s = s + "(";
            for (int j = 0; j < this.arity; ++j) {
                s = s + this.tuples[i][j] + (j < this.arity - 1 ? "," : "");
            }
            s = s + ") ";
            if (this.weights == null) continue;
            s = s + " with cost=" + this.weights[i] + ", ";
        }
        return s + (this.nbTuples > displayLimit ? "..." : "");
    }

    public boolean isSimilarTo(int arity, int nbTuples, String semantics, int[][] tuples) {
        if (semantics.equals("soft")) {
            throw new IllegalArgumentException();
        }
        if (this.arity != arity || this.nbTuples != nbTuples) {
            return false;
        }
        if (!this.semantics.equals(semantics)) {
            return false;
        }
        for (int i = 0; i < tuples.length; ++i) {
            for (int j = 0; j < tuples[i].length; ++j) {
                if (this.tuples[i][j] == tuples[i][j]) continue;
                return false;
            }
        }
        return true;
    }

    public String getStringListOfTuples() {
        StringBuffer s = new StringBuffer();
        for (int i = 0; i < this.tuples.length; ++i) {
            for (int j = 0; j < this.tuples[i].length; ++j) {
                s.append(this.tuples[i][j]);
                if (j == this.tuples[i].length - 1) continue;
                s.append(' ');
            }
            if (i == this.tuples.length - 1) continue;
            s.append('|');
        }
        return s.toString();
    }

    public int hashCode() {
        return this.index;
    }
}

