/*
 * Decompiled with CFR 0.152.
 */
package parser.absconparseur.components;

import parser.absconparseur.Toolkit;
import parser.absconparseur.intension.PredicateManager;

public class PPredicate {
    private String name;
    private String[] formalParameters;
    private String functionalExpression;
    private String[] unversalPostfixExpression;
    private int index;

    public String getName() {
        return this.name;
    }

    public String[] getFormalParameters() {
        return this.formalParameters;
    }

    public String[] getUniversalPostfixExpression() {
        return this.unversalPostfixExpression;
    }

    public PPredicate(String name, String formalParametersExpression, String functionalExpression) {
        this.name = name;
        this.formalParameters = PredicateManager.extractFormalParameters(formalParametersExpression, true);
        this.functionalExpression = functionalExpression.trim();
        this.unversalPostfixExpression = PredicateManager.buildUniversalPostfixExpression(functionalExpression, this.formalParameters);
        this.index = Integer.parseInt(name.substring(1).replaceAll("_", "00"));
    }

    public PPredicate(String name, String[] formalParametersExpression, String functionalExpression) {
        this.name = name;
        this.formalParameters = formalParametersExpression;
        this.functionalExpression = functionalExpression.trim();
        this.unversalPostfixExpression = PredicateManager.buildUniversalPostfixExpression(functionalExpression, this.formalParameters);
        this.index = Integer.parseInt(name.substring(1).replaceAll("_", "000"));
    }

    public void setFormalParameters(String[] formalParameters) {
        this.formalParameters = formalParameters;
    }

    public void setFunctionalExpression(String functionalExpression) {
        this.functionalExpression = functionalExpression;
    }

    public String toString() {
        return "  predicate " + this.name + " with functional expression = " + this.functionalExpression + " and (universal) postfix expression = " + Toolkit.buildStringFromTokens(this.unversalPostfixExpression);
    }

    public String getFunctionalExpression() {
        return this.functionalExpression;
    }

    public int hashCode() {
        return this.index;
    }
}

