/*
 * Decompiled with CFR 0.152.
 */
package parser.absconparseur.components;

import java.util.BitSet;
import parser.absconparseur.Toolkit;
import parser.absconparseur.components.PConstraint;
import parser.absconparseur.components.PDomain;
import parser.absconparseur.components.PPredicate;
import parser.absconparseur.components.PVariable;
import parser.absconparseur.intension.EvaluationManager;
import parser.absconparseur.intension.PredicateManager;

public class PIntensionConstraint
extends PConstraint {
    private PPredicate predicate;
    private String[] universalPostfixExpression;
    private String effectiveParametersExpression;
    private boolean knownAsExtensional = false;

    public PPredicate getPredicate() {
        return this.predicate;
    }

    public String[] getUniversalPostfixExpression() {
        return this.universalPostfixExpression;
    }

    public void setKnownAsExtensional() {
        this.knownAsExtensional = true;
    }

    public boolean isKnownAsExtensional() {
        return this.knownAsExtensional;
    }

    public PIntensionConstraint(String name, boolean known, PVariable[] scope, PPredicate predicate, String effectiveParametersExpression) {
        super(name, scope);
        this.predicate = predicate;
        this.effectiveParametersExpression = effectiveParametersExpression.trim();
        String[] variableNames = new String[scope.length];
        for (int i = 0; i < variableNames.length; ++i) {
            variableNames[i] = scope[i].getName();
        }
        this.universalPostfixExpression = PredicateManager.buildNewUniversalPostfixExpression(predicate.getUniversalPostfixExpression(), effectiveParametersExpression, variableNames);
        this.knownAsExtensional = known;
    }

    public PIntensionConstraint(String name, PVariable[] scope, PPredicate predicate, String effectiveParametersExpression) {
        this(name, false, scope, predicate, effectiveParametersExpression);
    }

    @Override
    public int computeCostOf(int[] tuple) {
        EvaluationManager evaluationManager = new EvaluationManager(this.universalPostfixExpression);
        boolean satisfied = evaluationManager.checkValues(tuple);
        return satisfied ? 0 : 1;
    }

    public boolean isADifference() {
        if (this.getArity() != 2) {
            return false;
        }
        if (!this.knownAsExtensional) {
            PDomain p1 = this.getScope()[0].getDomain();
            PDomain p2 = this.getScope()[1].getDomain();
            if (p1.getNbValues() <= 100 && p2.getNbValues() <= 100) {
                int[] val1 = p1.getValues();
                BitSet b2 = p2.getBitSetDomain();
                int[] couple = new int[2];
                for (int i = 0; i < val1.length; ++i) {
                    int val = val1[i];
                    if ((b2 == null || val >= 0 && !b2.get(val)) && (b2 != null || !p2.contains(val))) continue;
                    couple[0] = val;
                    couple[1] = val;
                    if (this.computeCostOf(couple) != 0) continue;
                    return false;
                }
                return true;
            }
        }
        return false;
    }

    @Override
    public String toString() {
        return super.toString() + ", and associated predicate " + this.predicate.getName() + " and universal predicate = " + Toolkit.buildStringFromTokens(this.universalPostfixExpression);
    }

    @Override
    public boolean isGuaranteedToBeDivisionByZeroFree() {
        EvaluationManager evaluationManager = new EvaluationManager(this.universalPostfixExpression);
        return evaluationManager.isGuaranteedToBeDivisionByZeroFree(this.scope);
    }

    @Override
    public boolean isGuaranteedToBeOverflowFree() {
        EvaluationManager evaluationManager = new EvaluationManager(this.universalPostfixExpression);
        return evaluationManager.isGuaranteedToBeOverflowFree(this.scope);
    }

    public String getEffectiveParametersExpression() {
        return this.effectiveParametersExpression;
    }

    public void setEffectiveParametersExpression(String effectiveParametersExpression) {
        this.effectiveParametersExpression = effectiveParametersExpression;
    }
}

