/*
 * Decompiled with CFR 0.152.
 */
package parser.absconparseur.components;

import parser.absconparseur.components.PGlobalConstraint;
import parser.absconparseur.components.PVariable;

public class PElement
extends PGlobalConstraint {
    private PVariable index;
    private Object[] table;
    private Object value;
    private int indexPositionInScope;
    private int[] tablePositionsInScope;
    private int valuePositionInScope;

    public PElement(String name, PVariable[] scope, PVariable indexVariable, Object[] table, Object value) {
        super(name, scope);
        this.index = indexVariable;
        this.table = table;
        this.value = value;
        this.indexPositionInScope = this.getPositionInScope(indexVariable);
        this.tablePositionsInScope = this.computeObjectPositionsInScope(table);
        this.valuePositionInScope = this.computeObjectPositionInScope(value);
    }

    @Override
    public int computeCostOf(int[] tuple) {
        int indexInTable = tuple[this.indexPositionInScope];
        Object object = this.table[indexInTable];
        int result = object instanceof Integer ? (Integer)object : tuple[this.tablePositionsInScope[indexInTable]];
        boolean satisfied = result == (this.value instanceof Integer ? (Integer)this.value : tuple[this.valuePositionInScope]);
        return satisfied ? 0 : 1;
    }

    @Override
    public String toString() {
        String s = super.toString() + " : element\n\t";
        s = s + "index=" + this.index.getName() + "  table=";
        for (int i = 0; i < this.table.length; ++i) {
            s = s + this.computeStringRepresentationOf(this.table[i]) + " ";
        }
        s = s + "  value=" + this.computeStringRepresentationOf(this.value);
        return s;
    }

    public PVariable getIndex() {
        return this.index;
    }

    public Object[] getTable() {
        return this.table;
    }

    public Object getValue() {
        return this.value;
    }
}

