/*
 * Decompiled with CFR 0.152.
 */
package parser.absconparseur.components;

import java.util.Arrays;
import java.util.BitSet;

public class PDomain {
    private String name;
    private int[] values;
    private int index;

    public String getName() {
        return this.name;
    }

    public int[] getValues() {
        return this.values;
    }

    public int getNbValues() {
        return this.values.length;
    }

    public BitSet getBitSetDomain() {
        if (this.values[0] < 0) {
            return null;
        }
        BitSet b = new BitSet();
        for (int i = 0; i < this.values.length; ++i) {
            b.set(this.values[i]);
        }
        return b;
    }

    public int getIntersectionSize(PDomain dom2) {
        if (this.getMaxValue() < dom2.getMinValue() || dom2.getMinValue() > this.getMaxValue()) {
            return 0;
        }
        BitSet b1 = this.getBitSetDomain();
        BitSet b2 = dom2.getBitSetDomain();
        if (b1 != null && b2 != null) {
            b1.and(b2);
            return b1.cardinality();
        }
        return -1;
    }

    public int getMinValue() {
        return this.values[0];
    }

    public int getMaxValue() {
        return this.values[this.values.length - 1];
    }

    public int getMaxAbsoluteValue() {
        return Math.max(Math.abs(this.values[0]), Math.abs(this.values[this.values.length - 1]));
    }

    public PDomain(String name, int[] values) {
        this.name = name;
        this.values = values;
        this.index = Integer.parseInt(name.substring(1));
    }

    public boolean contains(int value) {
        return Arrays.binarySearch(this.values, value) >= 0;
    }

    public String toString() {
        int displayLimit = 5;
        String s = "  domain " + this.name + " with " + this.values.length + " values : ";
        for (int i = 0; i < Math.min(this.values.length, displayLimit); ++i) {
            s = s + this.values[i] + " ";
        }
        return s + (this.values.length > displayLimit ? "..." : "");
    }

    public String getStringListOfValues() {
        int previousValue = this.values[0];
        boolean startedInterval = false;
        StringBuffer sb = new StringBuffer();
        for (int i = 1; i < this.values.length; ++i) {
            int currentValue = this.values[i];
            if (currentValue != previousValue + 1) {
                if (startedInterval) {
                    sb.append(previousValue + "");
                    startedInterval = false;
                } else {
                    sb.append(previousValue);
                }
                sb.append(" ");
            } else if (!startedInterval) {
                sb.append("" + previousValue + "..");
                startedInterval = true;
            }
            previousValue = currentValue;
        }
        if (startedInterval) {
            sb.append(previousValue + "");
        } else {
            sb.append(previousValue);
        }
        return sb.toString();
    }

    public int hashCode() {
        return this.index;
    }
}

