/*
 * Decompiled with CFR 0.152.
 */
package parser.absconparseur.components;

import parser.absconparseur.components.PGlobalConstraint;
import parser.absconparseur.components.PVariable;

public class PCumulative
extends PGlobalConstraint {
    private Task[] tasks;
    private int limit;

    public PCumulative(String name, PVariable[] scope, Task[] tasks, int limit) {
        super(name, scope);
        this.tasks = tasks;
        for (Task task : tasks) {
            task.setVariablePositions(this.computeObjectPositionInScope(task.origin), this.computeObjectPositionInScope(task.duration), this.computeObjectPositionInScope(task.end), this.computeObjectPositionInScope(task.height));
        }
        this.limit = limit;
    }

    @Override
    public int computeCostOf(int[] tuple) {
        for (Task task : this.tasks) {
            if (task.evaluate(tuple) != 1) continue;
            return 1;
        }
        for (int i = 0; i < this.tasks.length; ++i) {
            for (int period = this.tasks[i].originValue; period < this.tasks[i].endValue; ++period) {
                int heightSum = this.tasks[i].heightValue;
                for (int j = i + 1; j < this.tasks.length; ++j) {
                    if (period < this.tasks[j].originValue || period >= this.tasks[j].endValue) continue;
                    heightSum += this.tasks[j].heightValue;
                }
                if (heightSum <= this.limit) continue;
                return 1;
            }
        }
        return 0;
    }

    @Override
    public String toString() {
        String s = super.toString() + " : cumulative\n\t";
        for (int i = 0; i < this.tasks.length; ++i) {
            s = s + "  [origin=" + this.computeStringRepresentationOf(this.tasks[i].origin) + "(" + this.tasks[i].originPositionInScope + ")" + " duration=" + this.computeStringRepresentationOf(this.tasks[i].duration) + " ";
            s = s + "end=" + this.computeStringRepresentationOf(this.tasks[i].end) + " " + "height=" + this.computeStringRepresentationOf(this.tasks[i].height) + "]\n\t";
        }
        s = s + "nbTasks=" + this.tasks.length + " limit=" + this.limit;
        return s;
    }

    public Task[] getTasks() {
        return this.tasks;
    }

    public void setTasks(Task[] tasks) {
        this.tasks = tasks;
    }

    public int getLimit() {
        return this.limit;
    }

    public static class Task {
        private Object origin;
        private int originPositionInScope;
        private int originValue;
        private Object duration;
        private int durationPositionInScope;
        private int durationValue;
        private Object end;
        private int endPositionInScope;
        private int endValue;
        private Object height;
        private int heightPositionInScope;
        private int heightValue;

        public Task(Object origin, Object duration, Object end, Object height) {
            this.origin = origin;
            this.duration = duration;
            this.end = end;
            this.height = height;
        }

        private void setVariablePositions(int originPositionInScope, int durationPositionInScope, int endPositionInScope, int heightPositionInScope) {
            this.originPositionInScope = originPositionInScope;
            this.durationPositionInScope = durationPositionInScope;
            this.endPositionInScope = endPositionInScope;
            this.heightPositionInScope = heightPositionInScope;
        }

        private int evaluate(int[] tuple) {
            if (this.origin != null) {
                int n = this.originValue = this.origin instanceof Integer ? (Integer)this.origin : tuple[this.originPositionInScope];
            }
            if (this.duration != null) {
                int n = this.durationValue = this.duration instanceof Integer ? (Integer)this.duration : tuple[this.durationPositionInScope];
            }
            if (this.end != null) {
                int n = this.endValue = this.end instanceof Integer ? (Integer)this.end : tuple[this.endPositionInScope];
            }
            if (this.origin != null && this.duration != null && this.end != null && this.originValue + this.durationValue != this.endValue) {
                return 1;
            }
            if (this.origin == null) {
                this.originValue = this.endValue - this.durationValue;
            }
            if (this.end == null) {
                this.endValue = this.originValue + this.durationValue;
            }
            this.heightValue = this.height instanceof Integer ? (Integer)this.height : tuple[this.heightPositionInScope];
            return 0;
        }

        public void displayEvaluations() {
            System.out.println(this.originValue + " " + this.durationValue + " " + this.endValue + " " + this.heightValue);
        }

        public Object getOrigin() {
            return this.origin;
        }

        public Object getDuration() {
            return this.duration;
        }

        public Object getEnd() {
            return this.end;
        }

        public Object getHeight() {
            return this.height;
        }
    }
}

