/*
 * Decompiled with CFR 0.152.
 */
package parser.absconparseur.components;

import choco.kernel.model.constraints.Constraint;
import parser.absconparseur.components.PVariable;

public abstract class PConstraint {
    private int index;
    protected String name;
    protected PVariable[] scope;
    protected Constraint chocoCstr;

    public String getName() {
        return this.name;
    }

    public PVariable[] getScope() {
        return this.scope;
    }

    public int getPositionInScope(PVariable variable) {
        for (int i = 0; i < this.scope.length; ++i) {
            if (variable != this.scope[i]) continue;
            return i;
        }
        return -1;
    }

    public int getArity() {
        return this.scope.length;
    }

    public PConstraint(String name, PVariable[] scope) {
        this.name = name;
        this.scope = scope;
        this.index = Integer.parseInt(name.substring(1).replaceAll("_", "00"));
    }

    public int getMaximalCost() {
        return 1;
    }

    public abstract int computeCostOf(int[] var1);

    public String toString() {
        String s = "  constraint " + this.name + " with arity = " + this.scope.length + ", scope = ";
        s = s + this.scope[0].getName();
        for (int i = 1; i < this.scope.length; ++i) {
            s = s + " " + this.scope[i].getName();
        }
        return s;
    }

    public boolean isGuaranteedToBeDivisionByZeroFree() {
        return true;
    }

    public boolean isGuaranteedToBeOverflowFree() {
        return true;
    }

    public Constraint getChocoCstr() {
        return this.chocoCstr;
    }

    public void setChocoCstr(Constraint chocoCstr) {
        this.chocoCstr = chocoCstr;
    }

    public int hashCode() {
        return this.index;
    }
}

