/*
 * Decompiled with CFR 0.152.
 */
package parser.absconparseur;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.text.DecimalFormat;
import java.util.Arrays;
import java.util.Comparator;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.StringTokenizer;

public class Toolkit {
    public static final Comparator<int[]> lexicographicComparator = new Comparator<int[]>(){

        @Override
        public int compare(int[] t1, int[] t2) {
            for (int i = 0; i < t1.length; ++i) {
                if (t1[i] < t2[i]) {
                    return -1;
                }
                if (t1[i] <= t2[i]) continue;
                return 1;
            }
            return 0;
        }
    };

    public static int executeCommand(String completeCommand, PrintWriter out) {
        try {
            Process p = Runtime.getRuntime().exec(completeCommand);
            if (out != null) {
                String firstLine;
                BufferedReader in = new BufferedReader(new InputStreamReader(p.getInputStream()));
                String line = firstLine = in.readLine();
                while (line != null) {
                    out.println(line);
                    line = in.readLine();
                }
                in.close();
                out.flush();
            }
            p.waitFor();
            int status = p.exitValue();
            p.destroy();
            return status;
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
            return -1;
        }
    }

    public static String getMemoryInformation() {
        Runtime rt = Runtime.getRuntime();
        DecimalFormat df = new DecimalFormat("###,###,###,###");
        return "used = " + df.format(rt.totalMemory() - rt.freeMemory()) + " free = " + rt.freeMemory() + " total = " + rt.totalMemory() + " max = " + rt.maxMemory();
    }

    public static int[] buildArrayWithIncrementalValues(int length) {
        int[] t = new int[length];
        for (int i = 0; i < t.length; ++i) {
            t[i] = i;
        }
        return t;
    }

    public static int countNbOccurences(int[] t, int value) {
        int cpt = 0;
        for (int v : t) {
            if (v != value) continue;
            ++cpt;
        }
        return cpt;
    }

    public static void copy(String srcFileName, String dstFileName) {
        try {
            BufferedInputStream in = new BufferedInputStream(new FileInputStream(srcFileName));
            BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(dstFileName));
            byte[] bytes = new byte[1024];
            int nb = in.read(bytes, 0, bytes.length);
            while (nb > 0) {
                out.write(bytes, 0, nb);
                nb = in.read(bytes, 0, bytes.length);
            }
            in.close();
            out.close();
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
        }
    }

    public static boolean selectInDirectory(List<String> list, File dir, int limit, FileFilter fileFilter) {
        File f;
        int i;
        Object[] listDirectory = dir.list();
        Arrays.sort(listDirectory);
        for (i = 0; i < listDirectory.length; ++i) {
            f = new File(dir, (String)listDirectory[i]);
            if (!f.isFile() || !fileFilter.accept(f)) continue;
            list.add(f.getAbsolutePath());
            if (list.size() < limit) continue;
            return true;
        }
        for (i = 0; i < listDirectory.length; ++i) {
            f = new File(dir, (String)listDirectory[i]);
            if (!f.isDirectory() || !Toolkit.selectInDirectory(list, f, limit, fileFilter)) continue;
            return true;
        }
        return false;
    }

    public static String getRawInstanceName(String s) {
        int first = s.lastIndexOf(File.separator) != -1 ? s.lastIndexOf(File.separator) + 1 : 0;
        int last = s.lastIndexOf(".") != -1 ? s.lastIndexOf(".") : s.length();
        return first > last ? s.substring(first) : s.substring(first, last);
    }

    public static String getRelativeParentPackageNameOf(Class clazz) {
        String s = clazz.getName();
        int last = s.lastIndexOf(".");
        if (last == -1) {
            return null;
        }
        String path = s.substring(0, last);
        return path.substring(path.lastIndexOf(".") + 1);
    }

    public static String getRelativeClassNameOf(Class clazz) {
        String s = clazz.getName();
        return s.substring(s.lastIndexOf(".") + 1);
    }

    public static String getRelativeClassNameOf(Object object) {
        String s = object.getClass().getName();
        return s.substring(s.lastIndexOf(".") + 1);
    }

    public static String getSeparator(int mode) {
        return mode == 0 ? "," : "\n";
    }

    public static String getXMLBaseNameOf(String s) {
        int start = s.lastIndexOf(File.separator);
        start = start == -1 ? 0 : start + 1;
        int end = s.toLowerCase().lastIndexOf(".xml");
        end = end == -1 ? s.length() : end;
        return s.substring(start, end);
    }

    public static boolean isInteger(String token) {
        try {
            Integer.parseInt(token);
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    public static Integer parseInteger(String token) {
        try {
            int l = Integer.parseInt(token);
            return l;
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    public static Long parseLong(String token) {
        try {
            long l = Long.parseLong(token);
            return l;
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    public static String getFormattedCurrentDate() {
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTimeInMillis(System.currentTimeMillis());
        int year = calendar.get(1);
        int month = calendar.get(2);
        int day = calendar.get(5);
        int hour = calendar.get(11);
        int minute = calendar.get(12);
        DecimalFormat df = new DecimalFormat("00");
        return year + "_" + df.format(month) + "_" + df.format(day) + "_" + df.format(hour) + "_" + df.format(minute);
    }

    public static String getFormattedMemorySize(long size) {
        long m = size / 1000000L;
        long k = size / 1000L;
        return m + "M" + (k -= m * 1000L);
    }

    public static long getFreeMemory() {
        Runtime rt = Runtime.getRuntime();
        return rt.maxMemory() - rt.totalMemory() + rt.freeMemory();
    }

    public static long getUsedMemory() {
        Runtime rt = Runtime.getRuntime();
        return rt.totalMemory() - rt.freeMemory();
    }

    public static String getFormattedUsedMemorySize() {
        return Toolkit.getFormattedMemorySize(Toolkit.getUsedMemory());
    }

    public static String getAllocatedMemory() {
        Runtime rt = Runtime.getRuntime();
        return Toolkit.getFormattedMemorySize(rt.totalMemory());
    }

    public static boolean areIdentical(int[] t1, int[] t2) {
        for (int i = 0; i < t1.length; ++i) {
            if (t1[i] == t2[i]) continue;
            return false;
        }
        return true;
    }

    public static void copy(int[] dstSupport, int[] srcSupport) {
        for (int i = 0; i < dstSupport.length; ++i) {
            dstSupport[i] = srcSupport[i];
        }
    }

    public static int searchIn(String s, String[] t) {
        for (int i = 0; i < t.length; ++i) {
            if (!t[i].equals(s)) continue;
            return i;
        }
        return -1;
    }

    public static String buildStringFromInts(int[] t) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < t.length; ++i) {
            sb.append(t[i]);
            if (i >= t.length - 1) continue;
            sb.append(' ');
        }
        return sb.toString();
    }

    public static String buildStringFromTokens(String[] t) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < t.length; ++i) {
            sb.append(t[i]);
            if (i >= t.length - 1) continue;
            sb.append(' ');
        }
        return sb.toString();
    }

    public static String[] buildTokensFromString(String s) {
        StringTokenizer st = new StringTokenizer(s);
        String[] tokens = new String[st.countTokens()];
        for (int i = 0; i < tokens.length; ++i) {
            tokens[i] = st.nextToken();
        }
        return tokens;
    }

    public static String insertWhitespaceAround(String s, String t) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            boolean found = false;
            for (int j = 0; !found && j < t.length(); ++j) {
                if (t.charAt(j) != c) continue;
                found = true;
            }
            if (found) {
                sb.append(" ");
                sb.append(c);
                sb.append(" ");
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }
}

