/*
 * Decompiled with CFR 0.152.
 */
package parser.absconparseur;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;

public class ReflectionManager {
    public static final char JAR_SEPARATOR_CHAR = '/';
    private static Map<String, String> mapOfClassNames = new HashMap<String, String>();

    public static Class getFirstInnerClassOfInheritingFrom(Class cl, Class<?> targetClass) {
        Class<?>[] innerClasses = cl.getDeclaredClasses();
        for (int i = 0; i < innerClasses.length; ++i) {
            if (!targetClass.isAssignableFrom(innerClasses[i])) continue;
            return innerClasses[i];
        }
        return null;
    }

    private static String replaceAll(String s, char oldChar, char newChar) {
        StringBuffer sb = new StringBuffer(s);
        for (int i = 0; i < sb.length(); ++i) {
            if (sb.charAt(i) != oldChar) continue;
            sb.setCharAt(i, newChar);
        }
        return sb.toString();
    }

    private static String getAbsoluteClassNameOf(File classFile, String basicPackageName) {
        String s = ReflectionManager.replaceAll(classFile.getAbsolutePath(), File.separatorChar, '.');
        int firstIndex = s.indexOf(basicPackageName);
        assert (firstIndex != -1);
        int lastIndex = s.lastIndexOf(".");
        s = s.substring(firstIndex, lastIndex);
        return s;
    }

    private static void updateListIfSubclassing(List<Class> list, Class<?> rootClass, String absoluteClassName, int requiredModifiers, int forbiddenModifiers) {
        try {
            Class<?> c = Class.forName(absoluteClassName);
            if ((c.getModifiers() & requiredModifiers) == requiredModifiers && (c.getModifiers() & forbiddenModifiers) == 0 && rootClass.isAssignableFrom(c)) {
                list.add(c);
            }
        }
        catch (ClassNotFoundException e) {
            (e.getCause() == null ? e : e.getCause()).printStackTrace();
        }
    }

    public static List<Class> searchClassesInheritingFromIn(Class rootClass, File directory, int requiredModifiers, int forbiddenModifiers) {
        assert (directory.isDirectory());
        ArrayList<Class> list = new ArrayList<Class>();
        File[] files = directory.listFiles();
        for (int i = 0; i < files.length; ++i) {
            if (files[i].isDirectory()) {
                list.addAll(ReflectionManager.searchClassesInheritingFromIn(rootClass, files[i], requiredModifiers, forbiddenModifiers));
                continue;
            }
            if (!files[i].getName().endsWith(".class")) continue;
            ReflectionManager.updateListIfSubclassing(list, rootClass, ReflectionManager.getAbsoluteClassNameOf(files[i], rootClass.getPackage().getName()), requiredModifiers, forbiddenModifiers);
        }
        return list;
    }

    public static Enumeration getEntriesOf(String jarName) {
        try {
            JarFile jf = new JarFile(jarName);
            return jf.entries();
        }
        catch (IOException iOException) {
            return null;
        }
    }

    private static List<Class> searchClassesInheretingFromInJar(Class rootClass, String jarName, int requiredModifiers, int forbiddenModifiers) {
        ArrayList<Class> list = new ArrayList<Class>();
        Enumeration enumeration = ReflectionManager.getEntriesOf(jarName);
        if (enumeration == null) {
            return list;
        }
        while (enumeration.hasMoreElements()) {
            String name = ((ZipEntry)enumeration.nextElement()).getName();
            String packTmp = ReflectionManager.replaceAll(rootClass.getPackage().getName(), '.', '/');
            if (!name.endsWith(".class") || !name.startsWith(packTmp)) continue;
            name = ReflectionManager.replaceAll(name.substring(0, name.lastIndexOf(".")), '/', '.');
            ReflectionManager.updateListIfSubclassing(list, rootClass, name, requiredModifiers, forbiddenModifiers);
        }
        return list;
    }

    private static File getDirectoryOf(String classPathToken, String basicDirectory) {
        basicDirectory = ReflectionManager.replaceAll(basicDirectory, '.', File.separatorChar);
        return new File(classPathToken + (classPathToken.endsWith(File.separator) ? "" : File.separator) + basicDirectory);
    }

    private static File getDirectoryOf(String classPathToken, Class clazz) {
        return ReflectionManager.getDirectoryOf(classPathToken, clazz.getPackage().getName());
    }

    public static Class[] searchClassesInheritingFrom(Class rootClass, int requiredModifiers, int forbiddenModifiers) {
        ArrayList<Class> classes = new ArrayList<Class>();
        StringTokenizer st = new StringTokenizer(System.getProperty("java.class.path", "."), File.pathSeparator);
        while (st.hasMoreTokens()) {
            String classPathToken = st.nextToken();
            if (classPathToken.endsWith(".jar")) {
                classes.addAll(ReflectionManager.searchClassesInheretingFromInJar(rootClass, classPathToken, requiredModifiers, forbiddenModifiers));
                continue;
            }
            File file = ReflectionManager.getDirectoryOf(classPathToken, rootClass);
            if (!file.exists() || !file.isDirectory()) continue;
            classes.addAll(ReflectionManager.searchClassesInheritingFromIn(rootClass, file, requiredModifiers, forbiddenModifiers));
        }
        return classes.toArray(new Class[0]);
    }

    public static Field getFirstFieldOfWithType(Class cl, Class<?> targetClass) {
        Field[] fields = cl.getDeclaredFields();
        for (int i = 0; i < fields.length; ++i) {
            if (!targetClass.isAssignableFrom(fields[i].getType())) continue;
            return fields[i];
        }
        return cl.getSuperclass() == null ? null : ReflectionManager.getFirstFieldOfWithType(cl.getSuperclass(), targetClass);
    }

    public static DigestedFields getAllFieldsOfFieldOfInheritingFrom(Object object, Class targetClass) {
        Field field = ReflectionManager.getFirstFieldOfWithType(object.getClass(), targetClass);
        try {
            field.setAccessible(true);
            Object value = field.get(object);
            DigestedFields digest = new DigestedFields();
            for (Class innerClass = ReflectionManager.getFirstInnerClassOfInheritingFrom(object.getClass(), targetClass); innerClass != null; innerClass = innerClass.getSuperclass()) {
                Field[] fields = innerClass.getDeclaredFields();
                int cpt = 0;
                for (int i = 0; i < fields.length; ++i) {
                    fields[i].setAccessible(true);
                    if (fields[i].getName().startsWith("this") || fields[i].getType().getName().equals(object.getClass().getName())) continue;
                    digest.add(fields[i].getName(), fields[i].getType(), fields[i].get(value).toString(), cpt++);
                }
            }
            return digest;
        }
        catch (IllegalAccessException e) {
            (e.getCause() == null ? e : e.getCause()).printStackTrace();
            return null;
        }
    }

    public static String[][] getDescriptionOfDeclaredFieldsOf(Object object) {
        String[][] description = null;
        try {
            Class<?> cl = object.getClass();
            Field[] fields = cl.getDeclaredFields();
            description = new String[fields.length - 1][2];
            for (int i = 0; i < fields.length - 1; ++i) {
                fields[i].setAccessible(true);
                description[i][0] = fields[i].getName();
                String value = fields[i].get(object).toString();
                int position = value.lastIndexOf(47);
                description[i][1] = value = value.substring(position + 1);
            }
        }
        catch (Exception e) {
            (e.getCause() == null ? e : e.getCause()).printStackTrace();
        }
        return description;
    }

    public static String getStringConcatenationOfDeclaredFieldsOf(Object object) {
        StringBuffer sb = new StringBuffer();
        try {
            Class<?> cl = object.getClass();
            Field[] fields = cl.getDeclaredFields();
            for (int i = 0; i < fields.length - 1; ++i) {
                fields[i].setAccessible(true);
                String value = fields[i].get(object).toString();
                int position = value.lastIndexOf(47);
                value = value.substring(position + 1);
                if (i > 0) {
                    sb.append(" ");
                }
                sb.append(value);
            }
        }
        catch (Exception e) {
            (e.getCause() == null ? e : e.getCause()).printStackTrace();
        }
        return sb.toString();
    }

    private static String searchClassInDirectory(File directory, String name) {
        File[] files = directory.listFiles();
        for (int i = 0; i < files.length; ++i) {
            File entry = files[i];
            if (entry.isDirectory()) {
                String path = ReflectionManager.searchClassInDirectory(entry, name);
                if (path == null) continue;
                return path;
            }
            if (!entry.getName().equals(name)) continue;
            return entry.getPath();
        }
        return null;
    }

    private static String searchClassInJar(String jarName, String basicDirectory, String className) {
        Enumeration enumeration = ReflectionManager.getEntriesOf(jarName);
        if (enumeration == null) {
            return null;
        }
        while (enumeration.hasMoreElements()) {
            String name = ((ZipEntry)enumeration.nextElement()).getName();
            if (!name.startsWith(basicDirectory) || !name.substring(name.lastIndexOf(47) + 1).equals(className)) continue;
            return ReflectionManager.replaceAll(name.substring(0, name.lastIndexOf(".")), '/', '.');
        }
        return null;
    }

    public static String searchAbsoluteNameOf(String basicPackage, String className) {
        StringTokenizer st = new StringTokenizer(System.getProperty("java.class.path", "."), File.pathSeparator);
        while (st.hasMoreTokens()) {
            String path;
            String classPathToken = st.nextToken();
            if (classPathToken.endsWith(".jar")) {
                String basicDirectory = ReflectionManager.replaceAll(basicPackage, '.', '/');
                path = ReflectionManager.searchClassInJar(classPathToken, basicDirectory, className + ".class");
                if (path == null) continue;
                return path;
            }
            File directory = ReflectionManager.getDirectoryOf(classPathToken, basicPackage);
            if (!directory.exists() || !directory.isDirectory() || (path = ReflectionManager.searchClassInDirectory(directory, className + ".class")) == null) continue;
            path = path.substring(classPathToken.length() + (classPathToken.endsWith(File.separator) ? 0 : 1), path.lastIndexOf("."));
            return ReflectionManager.replaceAll(path, File.separatorChar, '.');
        }
        return null;
    }

    public static Method searchMethod(Class clazz, String methodName, int modifiers) {
        Method[] allClassMethods = clazz.getMethods();
        for (int j = 0; j < allClassMethods.length; ++j) {
            if (!allClassMethods[j].getName().equals(methodName) || (allClassMethods[j].getModifiers() & modifiers) != modifiers) continue;
            return allClassMethods[j];
        }
        return null;
    }

    public static Method[] searchMethods(Class[] classes, String methodName, int modifiers) {
        Method[] methods = new Method[classes.length];
        for (int i = 0; i < methods.length; ++i) {
            methods[i] = ReflectionManager.searchMethod(classes[i], methodName, modifiers);
        }
        return methods;
    }

    public static Constructor searchFirstConstructor(Class clazz, int modifiers) {
        Constructor<?>[] constructors = clazz.getConstructors();
        Constructor<?> constructor = null;
        for (int i = 0; i < constructors.length; ++i) {
            if ((constructors[i].getModifiers() & modifiers) != modifiers) continue;
            constructor = constructors[i];
        }
        return constructor;
    }

    public static Constructor[] searchFirstConstructors(Class[] classes, int modifiers) {
        Constructor[] constructors = new Constructor[classes.length];
        for (int i = 0; i < constructors.length; ++i) {
            constructors[i] = ReflectionManager.searchFirstConstructor(classes[i], modifiers);
            if (constructors[i] != null) continue;
            throw new IllegalArgumentException("Missing constructor in " + classes[i].getName());
        }
        return constructors;
    }

    public static Object getInstanceOf(Class clazz) {
        try {
            return clazz.newInstance();
        }
        catch (Exception e) {
            (e.getCause() == null ? e : e.getCause()).printStackTrace();
            return null;
        }
    }

    public static Object getInstanceOf(String className) {
        try {
            return Class.forName(className).newInstance();
        }
        catch (Exception e) {
            (e.getCause() == null ? e : e.getCause()).printStackTrace();
            return null;
        }
    }

    public static Object invokeStaticMethod(String className, String methodName) {
        try {
            return Class.forName(className).getDeclaredMethod(methodName, new Class[]{null}).invoke(null, (Object[])null);
        }
        catch (Exception e) {
            (e.getCause() == null ? e : e.getCause()).printStackTrace();
            return null;
        }
    }

    public static Object getInstanceOf(String className, Class rootClass) {
        String classPackageName = rootClass.getPackage().getName();
        String key = classPackageName + className;
        String absoluteClassName = mapOfClassNames.get(key);
        if (absoluteClassName == null) {
            absoluteClassName = ReflectionManager.searchAbsoluteNameOf(rootClass.getPackage().getName(), className);
            if (absoluteClassName == null) {
                throw new RuntimeException("Class " + className + " not found");
            }
            mapOfClassNames.put(key, absoluteClassName);
        }
        try {
            Class<?> cn = Class.forName(absoluteClassName);
            Class<?> rcn = Class.forName(rootClass.getName());
            if (!rcn.isAssignableFrom(cn)) {
                throw new RuntimeException(absoluteClassName + " does not extend " + rootClass.getName());
            }
            if (Modifier.isAbstract(cn.getModifiers())) {
                throw new RuntimeException(className + " is abstract");
            }
            return cn.newInstance();
        }
        catch (Exception e) {
            (e.getCause() == null ? e : e.getCause()).printStackTrace();
            return null;
        }
    }

    public static Object getInstanceOf(String className, Object[] objects) {
        try {
            Class<?> cn = Class.forName(className);
            Constructor<?>[] cs = cn.getConstructors();
            assert (cs.length == 1);
            return cs[0].newInstance(objects);
        }
        catch (Exception e) {
            (e.getCause() == null ? e : e.getCause()).printStackTrace();
            return null;
        }
    }

    public static Object getArrayInstance(String className, int[] lengths) {
        try {
            return Array.newInstance(Class.forName(className), lengths);
        }
        catch (Exception e) {
            (e.getCause() == null ? e : e.getCause()).printStackTrace();
            return null;
        }
    }

    public static class DigestedFields {
        private List<String> names = new LinkedList<String>();
        private List<Class> types = new LinkedList<Class>();
        private List<String> values = new LinkedList<String>();

        public String getName(int i) {
            return this.names.get(i);
        }

        public Class getType(int i) {
            return this.types.get(i);
        }

        public String getValue(int i) {
            return this.values.get(i);
        }

        public int getLength() {
            return this.names.size();
        }

        public void add(String name, Class type, String value, int i) {
            this.names.add(name);
            this.types.add(type);
            this.values.add(value);
        }
    }
}

