/*
 * Decompiled with CFR 0.152.
 */
package parser.absconparseur;

public class PredicateTokens {
    public static final String ADD = "add";
    public static final String SUB = "sub";
    public static final String MUL = "mul";
    public static final String DIV = "div";
    public static final String MOD = "mod";
    public static final String POW = "pow";
    public static final String NEG = "neg";
    public static final String ABS = "abs";
    public static final String MIN = "min";
    public static final String MAX = "max";
    public static final String MINCHOCO = "minChoco";
    public static final String MAXCHOCO = "maxChoco";
    public static final String IF = "if";
    public static final String TRUE = "true";
    public static final String FALSE = "false";
    public static final String NOT = "not";
    public static final String AND = "and";
    public static final String OR = "or";
    public static final String XOR = "xor";
    public static final String IFF = "iff";
    public static final String EQ = "eq";
    public static final String NE = "ne";
    public static final String GT = "gt";
    public static final String GE = "ge";
    public static final String LT = "lt";
    public static final String LE = "le";
    public static final String ID = "id";
    public static final String VAR = "var";
    public static final String CST = "cst";
    public static final String DISTEQ = "distEQ";
    public static final String DISTNEQ = "distNEQ";
    public static final String DISTGT = "distGT";
    public static final String DISTLT = "distLT";
    public static final String OPPSIGN = "oppSign";

    private static String function(String functionName, Object operand) {
        return operand + " " + functionName + " ";
    }

    private static String function(String functionName, Object operand1, Object operand2) {
        return operand2 + " " + operand1 + " " + functionName + " ";
    }

    public static String function(String functionName, Object operand1, Object operand2, Object operand3) {
        return operand3 + " " + operand2 + " " + operand1 + " " + functionName + " ";
    }

    public static String function(String functionName, Object[] operands) {
        String s = "";
        for (int i = operands.length - 1; i >= 0; --i) {
            s = s + operands[i] + " ";
        }
        return s + functionName + " ";
    }

    public static String eq(Object operand1, Object operand2) {
        return PredicateTokens.function(EQ, operand1, operand2);
    }

    public static String eq(Object operand1, Object operand2, Object operand3) {
        return PredicateTokens.function(EQ, operand1, operand2, operand3);
    }

    public static String eq(Object[] operands) {
        return PredicateTokens.function(EQ, operands);
    }

    public static String ne(Object operand1, Object operand2) {
        return PredicateTokens.function(NE, operand1, operand2);
    }

    public static String gt(Object operand1, Object operand2) {
        return PredicateTokens.function(GT, operand1, operand2);
    }

    public static String ge(Object operand1, Object operand2) {
        return PredicateTokens.function(GE, operand1, operand2);
    }

    public static String lt(Object operand1, Object operand2) {
        return PredicateTokens.function(LT, operand1, operand2);
    }

    public static String le(Object operand1, Object operand2) {
        return PredicateTokens.function(LE, operand1, operand2);
    }

    public static String not(Object operand1) {
        return PredicateTokens.function(NOT, operand1);
    }

    public static String and(Object operand1, Object operand2) {
        return PredicateTokens.function(AND, operand1, operand2);
    }

    public static String and(Object operand1, Object operand2, Object operand3) {
        return PredicateTokens.function(AND, operand1, operand2, operand3);
    }

    public static String or(Object operand1, Object operand2) {
        return PredicateTokens.function(OR, operand1, operand2);
    }

    public static String or(Object operand1, Object operand2, Object operand3) {
        return PredicateTokens.function(OR, operand1, operand2, operand3);
    }

    public static String functionIf(Object operand1, Object operand2, Object operand3) {
        return PredicateTokens.function(IF, operand1, operand2, operand3);
    }

    public static String abs(Object operand) {
        return PredicateTokens.function(ABS, operand);
    }

    public static String div(Object operand1, Object operand2) {
        return PredicateTokens.function(DIV, operand1, operand2);
    }

    public static String mul(Object operand1, Object operand2) {
        return PredicateTokens.function(MUL, operand1, operand2);
    }

    public static String mod(Object operand1, Object operand2) {
        return PredicateTokens.function(MOD, operand1, operand2);
    }

    public static String sub(Object operand1, Object operand2) {
        return PredicateTokens.function(SUB, operand1, operand2);
    }

    public static String add(Object operand1) {
        return PredicateTokens.function(ADD, operand1);
    }

    public static String add(Object operand1, Object operand2) {
        return PredicateTokens.function(ADD, operand1, operand2);
    }

    public static String pow(Object operand1, Object operand2) {
        return PredicateTokens.function(POW, operand1, operand2);
    }

    public static String id(Object operand) {
        return PredicateTokens.function(ID, operand);
    }

    public static String distEq(Object operand1, Object operand2, Object operand3) {
        return PredicateTokens.function(DISTEQ, operand1, operand2, operand3);
    }

    public static String distNeq(Object operand1, Object operand2, Object operand3) {
        return PredicateTokens.function(DISTNEQ, operand1, operand2, operand3);
    }

    public static String distGt(Object operand1, Object operand2, Object operand3) {
        return PredicateTokens.function(DISTGT, operand1, operand2, operand3);
    }

    public static String distLt(Object operand1, Object operand2, Object operand3) {
        return PredicateTokens.function(DISTLT, operand1, operand2, operand3);
    }

    public static String distLt(Object operand1, Object operand2) {
        return PredicateTokens.function(OPPSIGN, operand1, operand2);
    }

    public static enum RelationalOperator {
        EQ,
        NE,
        GE,
        GT,
        LE,
        LT;


        public static String getStringFor(RelationalOperator operator) {
            if (operator == EQ) {
                return PredicateTokens.EQ;
            }
            if (operator == NE) {
                return PredicateTokens.NE;
            }
            if (operator == GE) {
                return PredicateTokens.GE;
            }
            if (operator == GT) {
                return PredicateTokens.GT;
            }
            if (operator == LE) {
                return PredicateTokens.LE;
            }
            if (operator == LT) {
                return PredicateTokens.LT;
            }
            return null;
        }

        public static RelationalOperator getRelationalOperatorFor(String string) {
            if (string.equals(PredicateTokens.EQ)) {
                return EQ;
            }
            if (string.equals(PredicateTokens.NE)) {
                return NE;
            }
            if (string.equals(PredicateTokens.GE)) {
                return GE;
            }
            if (string.equals(PredicateTokens.GT)) {
                return GT;
            }
            if (string.equals(PredicateTokens.LE)) {
                return LE;
            }
            if (string.equals(PredicateTokens.LT)) {
                return LT;
            }
            return null;
        }
    }
}

