/*
 * Decompiled with CFR 0.152.
 */
package choco.kernel.solver.variables.scheduling;

import choco.kernel.common.IIndex;
import choco.kernel.common.util.DisposableIntIterator;
import choco.kernel.common.util.IntIterator;
import choco.kernel.memory.IEnvironment;
import choco.kernel.memory.PartiallyStoredIntVector;
import choco.kernel.memory.PartiallyStoredVector;
import choco.kernel.model.variables.scheduling.ITaskVariable;
import choco.kernel.solver.ContradictionException;
import choco.kernel.solver.Solver;
import choco.kernel.solver.constraints.AbstractSConstraint;
import choco.kernel.solver.constraints.SConstraint;
import choco.kernel.solver.propagation.VarEvent;
import choco.kernel.solver.variables.AbstractVar;
import choco.kernel.solver.variables.Var;
import choco.kernel.solver.variables.integer.IntDomainVar;
import choco.kernel.solver.variables.scheduling.AbstractTask;
import java.util.Iterator;

public final class TaskVar
extends AbstractTask
implements Var,
ITaskVariable<IntDomainVar>,
IIndex {
    public Solver solver;
    protected final IntDomainVar start;
    protected final IntDomainVar end;
    protected final IntDomainVar duration;
    private int index = -1;
    protected PartiallyStoredVector<SConstraint> constraints;

    public TaskVar(Solver solver, int id, String name, IntDomainVar start, IntDomainVar end, IntDomainVar duration) {
        super(id, name);
        this.solver = solver;
        this.start = start;
        this.end = end;
        this.duration = duration;
        IEnvironment env = solver.getEnvironment();
        this.constraints = env.makePartiallyStoredVector();
        this.index = solver.getIndexfactory().getIndex();
    }

    @Override
    public String toString() {
        return this.name;
    }

    @Override
    public int getIndexIn(int masterIndex) {
        return this.index;
    }

    @Override
    public void setIndexIn(int masterInd, int ind) {
        this.index = ind;
    }

    @Override
    public final IntDomainVar start() {
        return this.start;
    }

    @Override
    public final IntDomainVar end() {
        return this.end;
    }

    @Override
    public final IntDomainVar duration() {
        return this.duration;
    }

    @Override
    public int getECT() {
        return this.end.getInf();
    }

    @Override
    public int getEST() {
        return this.start.getInf();
    }

    @Override
    public int getLCT() {
        return this.end.getSup();
    }

    @Override
    public int getLST() {
        return this.start.getSup();
    }

    @Override
    public int getMaxDuration() {
        return this.duration.getSup();
    }

    @Override
    public int getMinDuration() {
        return this.duration.getInf();
    }

    @Override
    public boolean hasConstantDuration() {
        return this.duration.isInstantiated();
    }

    @Override
    public boolean isScheduled() {
        return this.isInstantiated();
    }

    public VarEvent<? extends AbstractVar> getEvent() {
        return null;
    }

    @Override
    public SConstraint getConstraint(int i) {
        return this.constraints.get(i);
    }

    @Override
    public int getNbConstraints() {
        return this.constraints.size();
    }

    @Override
    public PartiallyStoredVector<SConstraint> getConstraintVector() {
        return this.constraints;
    }

    @Override
    public PartiallyStoredIntVector getIndexVector() {
        return null;
    }

    @Override
    public int getVarIndex(int constraintIndex) {
        return -1;
    }

    public void eraseConstraint(SConstraint c) {
        this.constraints.remove(c);
    }

    @Override
    public int addConstraint(SConstraint c, int varIdx, boolean dynamicAddition) {
        int constraintIdx = dynamicAddition ? this.constraints.add(c) : this.constraints.staticAdd(c);
        return constraintIdx;
    }

    @Override
    public Iterator<SConstraint> getConstraintsIterator() {
        return new Iterator<SConstraint>(){
            IntIterator indices;
            {
                this.indices = TaskVar.this.constraints.getIndexIterator();
            }

            @Override
            public boolean hasNext() {
                return this.indices.hasNext();
            }

            @Override
            public SConstraint next() {
                return TaskVar.this.constraints.get(this.indices.next());
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public void updateNbVarInstanciated() {
        DisposableIntIterator cstIter = this.constraints.getIndexIterator();
        while (cstIter.hasNext()) {
            AbstractSConstraint cstr = (AbstractSConstraint)this.constraints.get(cstIter.next());
            cstr.decNbVarNotInst();
        }
        cstIter.dispose();
    }

    @Override
    public void setSolver(Solver solver) {
        this.solver = solver;
    }

    @Override
    public Solver getSolver() {
        return this.solver;
    }

    @Override
    public boolean isInstantiated() {
        return this.start.isInstantiated() && this.end.isInstantiated() && this.duration.isInstantiated();
    }

    @Override
    public void fail() throws ContradictionException {
        this.solver.getPropagationEngine().raiseContradiction(this, 1);
    }
}

