/*
 * Decompiled with CFR 0.152.
 */
package choco.kernel.solver.variables.scheduling;

import choco.kernel.common.IDotty;
import choco.kernel.solver.variables.scheduling.ITask;

public abstract class AbstractTask
implements ITask,
IDotty {
    protected final int id;
    protected final String name;

    public AbstractTask(int id, String name) {
        this.id = id;
        this.name = name;
    }

    @Override
    public final int getID() {
        return this.id;
    }

    @Override
    public final String getName() {
        return this.name;
    }

    @Override
    public final int getSlack() {
        return this.getECT() - this.getLST();
    }

    @Override
    public final double getCentroid() {
        return (double)(this.getECT() + this.getLST()) / 2.0;
    }

    @Override
    public final boolean hasCompulsoryPart() {
        return this.getECT() > this.getLST();
    }

    protected final String format(int lb, int ub) {
        return lb == ub ? String.valueOf(lb) : lb + ".." + ub;
    }

    public final String toDotty(String label, boolean format, String ... options) {
        StringBuilder b = new StringBuilder();
        b.append(this.getID()).append("[ shape=record,");
        b.append("label=\"{ ");
        b.append('{').append(this.getEST()).append('|');
        b.append(this.format(this.getMinDuration(), this.getMaxDuration()));
        b.append('|').append(this.getECT()).append('}');
        b.append('|').append(this.getName());
        if (!this.isScheduled()) {
            b.append('|');
            b.append('{').append(this.getLST()).append('|').append(this.getSlack()).append('|').append(this.getLCT()).append('}');
        }
        b.append(" }");
        if (label != null) {
            b.append(label);
        }
        b.append(" \"");
        if (format) {
            if (this.isScheduled()) {
                b.append(", style=bold, color=firebrick");
            } else {
                b.append(", style=dashed, color=navyblue");
            }
        }
        if (options != null) {
            for (int i = 0; i < options.length; ++i) {
                b.append(", ").append(options[i]);
            }
        }
        b.append(" ];");
        return new String(b);
    }

    @Override
    public String toDotty() {
        return this.toDotty(null, true, new String[0]);
    }

    @Override
    public String pretty() {
        StringBuilder b = new StringBuilder();
        b.append(this.getName()).append(":[");
        b.append(this.format(this.getEST(), this.getLST())).append(" + ");
        b.append(this.format(this.getMinDuration(), this.getMaxDuration())).append(" -> ");
        b.append(this.format(this.getECT(), this.getLCT())).append("]");
        return new String(b);
    }

    public String toString() {
        return this.getName() + "[" + this.getEST() + ", " + this.getLCT() + "]";
    }
}

