/*
 * Decompiled with CFR 0.152.
 */
package choco.kernel.solver.variables;

import choco.kernel.common.HashCoding;
import choco.kernel.common.util.DisposableIntIterator;
import choco.kernel.common.util.IntIterator;
import choco.kernel.memory.IEnvironment;
import choco.kernel.memory.PartiallyStoredIntVector;
import choco.kernel.memory.PartiallyStoredVector;
import choco.kernel.solver.ContradictionException;
import choco.kernel.solver.Solver;
import choco.kernel.solver.constraints.AbstractSConstraint;
import choco.kernel.solver.constraints.SConstraint;
import choco.kernel.solver.propagation.VarEvent;
import choco.kernel.solver.variables.Var;
import java.util.HashMap;
import java.util.Iterator;

public abstract class AbstractVar
implements Var {
    public Solver solver;
    protected String name;
    private int index = -1;
    protected VarEvent<? extends AbstractVar> event;
    protected PartiallyStoredVector<SConstraint> constraints;
    protected PartiallyStoredIntVector indices;
    private static int ABSTRACTVAR_EXTENSIONS_NB = 0;
    private static final HashMap<String, Integer> REGISTERED_ABSTRACTVAR_EXTENSIONS = new HashMap();
    public Object[] extensions = new Object[4];

    public static int getAbstractVarExtensionNumber(String name) {
        Integer ind = REGISTERED_ABSTRACTVAR_EXTENSIONS.get(name);
        if (ind == null) {
            ind = ABSTRACTVAR_EXTENSIONS_NB++;
            REGISTERED_ABSTRACTVAR_EXTENSIONS.put(name, ind);
        }
        return ind;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public AbstractVar(Solver solver, String name) {
        this.solver = solver;
        this.name = name;
        IEnvironment env = solver.getEnvironment();
        this.constraints = env.makePartiallyStoredVector();
        this.indices = env.makePartiallyStoredIntVector();
        this.index = solver.getIndexfactory().getIndex();
    }

    public int hashCode() {
        return HashCoding.hashCodeMe(new Object[]{this.index});
    }

    @Override
    public int getIndexIn(int masterIndex) {
        return this.index;
    }

    @Override
    public void setIndexIn(int masterInd, int ind) {
        this.index = ind;
    }

    public void setExtension(int extensionNumber, Object extension) {
        if (extensionNumber >= this.extensions.length) {
            Object[] newArray = new Object[this.extensions.length * 2];
            System.arraycopy(this.extensions, 0, newArray, 0, this.extensions.length);
            this.extensions = newArray;
        }
        this.extensions[extensionNumber] = extension;
    }

    public Object getExtension(int extensionNumber) {
        return this.extensions[extensionNumber];
    }

    public String toString() {
        return this.name;
    }

    public VarEvent<? extends AbstractVar> getEvent() {
        return this.event;
    }

    @Override
    public SConstraint getConstraint(int i) {
        return this.constraints.get(i);
    }

    @Override
    public int getNbConstraints() {
        return this.constraints.size();
    }

    @Override
    public PartiallyStoredVector<SConstraint> getConstraintVector() {
        return this.constraints;
    }

    @Override
    public PartiallyStoredIntVector getIndexVector() {
        return this.indices;
    }

    @Override
    public int getVarIndex(int constraintIndex) {
        return this.indices.get(constraintIndex);
    }

    public void eraseConstraint(SConstraint c) {
        int idx = this.constraints.remove(c);
        this.indices.remove(idx);
    }

    @Override
    public int addConstraint(SConstraint c, int varIdx, boolean dynamicAddition) {
        int constraintIdx;
        if (dynamicAddition) {
            constraintIdx = this.constraints.add(c);
            this.indices.add(varIdx);
        } else {
            constraintIdx = this.constraints.staticAdd(c);
            this.indices.staticAdd(varIdx);
        }
        return constraintIdx;
    }

    @Override
    public Iterator<SConstraint> getConstraintsIterator() {
        return new Iterator<SConstraint>(){
            IntIterator indices;
            {
                this.indices = AbstractVar.this.constraints.getIndexIterator();
            }

            @Override
            public boolean hasNext() {
                return this.indices.hasNext();
            }

            @Override
            public SConstraint next() {
                return AbstractVar.this.constraints.get(this.indices.next());
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    @Override
    public void fail() throws ContradictionException {
    }

    public void updateNbVarInstanciated() {
        DisposableIntIterator cstIter = this.constraints.getIndexIterator();
        while (cstIter.hasNext()) {
            AbstractSConstraint cstr = (AbstractSConstraint)this.constraints.get(cstIter.next());
            cstr.decNbVarNotInst();
        }
        cstIter.dispose();
    }
}

