/*
 * Decompiled with CFR 0.152.
 */
package choco.kernel.solver.search.set;

import choco.kernel.solver.ContradictionException;
import choco.kernel.solver.branch.AbstractIntBranching;
import choco.kernel.solver.variables.set.SetVar;
import java.util.logging.Level;

public abstract class AbstractSetBranching
extends AbstractIntBranching {
    @Override
    public int getNextBranch(Object x, int i) {
        if (i == 1) {
            return 2;
        }
        return 0;
    }

    @Override
    public boolean finishedBranching(Object x, int i) {
        return i == 2;
    }

    @Override
    public void goDownBranch(Object x, int numBranch) throws ContradictionException {
        super.goDownBranch(x, numBranch);
        Object[] xx = (Object[])x;
        SetVar var = (SetVar)xx[0];
        int val = (Integer)xx[1];
        if (numBranch == 1) {
            var.setValIn(val);
            this.manager.solver.propagate();
        } else if (numBranch == 2) {
            var.setValOut(val);
            this.manager.solver.propagate();
        }
    }

    @Override
    public void goUpBranch(Object x, int i) throws ContradictionException {
        super.goUpBranch(x, i);
    }

    public void goUpBranch(Object x, int i, int numBranch) throws ContradictionException {
        this.goUpBranch(x, numBranch);
    }

    @Override
    protected void logDownBranch(Object x, int i) {
        if (logger.isLoggable(Level.FINE)) {
            Object[] xx = (Object[])x;
            Object var = xx[0];
            int val = (Integer)xx[1];
            int n = this.manager.solver.getEnvironment().getWorldIndex();
            if (n <= this.manager.getLoggingMaxDepth()) {
                logger.log(Level.FINE, LOG_DOWN_MSG, new Object[]{new Integer(n), var, this.getDecisionLogMsg(i) + val + " branch ", new Integer(i)});
            }
        }
    }

    @Override
    protected void logUpBranch(Object x, int i) {
        if (logger.isLoggable(Level.FINE)) {
            Object[] xx = (Object[])x;
            Object var = xx[0];
            int val = (Integer)xx[1];
            int n = this.manager.solver.getEnvironment().getWorldIndex();
            if (n <= this.manager.getLoggingMaxDepth()) {
                logger.log(Level.FINE, LOG_UP_MSG, new Object[]{new Integer(n + 1), var, this.getDecisionLogMsg(i) + val + " branch ", new Integer(i)});
            }
        }
    }
}

