/*
 * Decompiled with CFR 0.152.
 */
package choco.kernel.solver.search.integer;

import choco.kernel.solver.ContradictionException;
import choco.kernel.solver.Solver;
import choco.kernel.solver.constraints.integer.IntSConstraint;
import choco.kernel.solver.search.integer.AbstractIntVarSelector;
import choco.kernel.solver.variables.integer.IntDomainVar;
import java.util.List;

public abstract class HeuristicIntVarSelector
extends AbstractIntVarSelector {
    public HeuristicIntVarSelector(Solver solver) {
        this.solver = solver;
    }

    public abstract IntDomainVar getMinVar(List<IntDomainVar> var1) throws ContradictionException;

    public abstract IntDomainVar getMinVar(IntDomainVar[] var1) throws ContradictionException;

    public abstract IntDomainVar getMinVar(Solver var1) throws ContradictionException;

    @Override
    public IntDomainVar selectIntVar() throws ContradictionException {
        if (null != this.vars) {
            return this.getMinVar(this.vars);
        }
        return this.getMinVar(this.solver);
    }

    public IntDomainVar getMinVar(IntSConstraint c) throws ContradictionException {
        IntDomainVar[] vars = new IntDomainVar[c.getNbVars()];
        for (int i = 0; i < c.getNbVars(); ++i) {
            vars[i] = c.getIntVar(i);
        }
        return this.getMinVar(vars);
    }

    public abstract List<IntDomainVar> getAllMinVars(Solver var1) throws ContradictionException;

    public abstract List<IntDomainVar> getAllMinVars(IntDomainVar[] var1) throws ContradictionException;

    public abstract List<IntDomainVar> getAllMinVars(IntSConstraint var1) throws ContradictionException;

    public List<IntDomainVar> selectTiedIntVars() throws ContradictionException {
        if (null != this.vars) {
            return this.getAllMinVars(this.vars);
        }
        return this.getAllMinVars(this.solver);
    }
}

