/*
 * Decompiled with CFR 0.152.
 */
package choco.kernel.solver.search.integer;

import choco.kernel.solver.ContradictionException;
import choco.kernel.solver.Solver;
import choco.kernel.solver.constraints.integer.IntSConstraint;
import choco.kernel.solver.search.integer.HeuristicIntVarSelector;
import choco.kernel.solver.variables.integer.IntDomainVar;
import java.util.ArrayList;
import java.util.List;

public abstract class DoubleHeuristicIntVarSelector
extends HeuristicIntVarSelector {
    public DoubleHeuristicIntVarSelector(Solver solver) {
        super(solver);
    }

    public abstract double getHeuristic(IntDomainVar var1) throws ContradictionException;

    public double getHeuristic(IntSConstraint c, int i) throws ContradictionException {
        return this.getHeuristic(c.getIntVar(i));
    }

    @Override
    public IntDomainVar getMinVar(List<IntDomainVar> vars) throws ContradictionException {
        double minValue = Double.POSITIVE_INFINITY;
        IntDomainVar v0 = null;
        for (IntDomainVar v : vars) {
            double val;
            if (v.isInstantiated() || !((val = this.getHeuristic(v)) < minValue)) continue;
            minValue = val;
            v0 = v;
        }
        return v0;
    }

    @Override
    public IntDomainVar getMinVar(IntDomainVar[] vars) throws ContradictionException {
        double minValue = Double.POSITIVE_INFINITY;
        IntDomainVar v0 = null;
        for (IntDomainVar v : vars) {
            double val;
            if (v.isInstantiated() || !((val = this.getHeuristic(v)) < minValue)) continue;
            minValue = val;
            v0 = v;
        }
        return v0;
    }

    @Override
    public IntDomainVar getMinVar(Solver solver) throws ContradictionException {
        double minValue = Double.POSITIVE_INFINITY;
        IntDomainVar v0 = null;
        int n = solver.getNbIntVars();
        for (int i = 0; i < n; ++i) {
            double val;
            IntDomainVar v = (IntDomainVar)solver.getIntVar(i);
            if (v.isInstantiated() || !((val = this.getHeuristic(v)) < minValue)) continue;
            minValue = val;
            v0 = v;
        }
        return v0;
    }

    @Override
    public List<IntDomainVar> getAllMinVars(Solver solver) throws ContradictionException {
        ArrayList<IntDomainVar> res = new ArrayList<IntDomainVar>();
        double minValue = Double.POSITIVE_INFINITY;
        int n = solver.getNbIntVars();
        for (int i = 0; i < n; ++i) {
            IntDomainVar v = (IntDomainVar)solver.getIntVar(i);
            if (v.isInstantiated()) continue;
            double val = this.getHeuristic(v);
            if (val < minValue) {
                res.clear();
                res.add(v);
                minValue = val;
                continue;
            }
            if (val != minValue) continue;
            res.add(v);
        }
        return res;
    }

    @Override
    public List<IntDomainVar> getAllMinVars(IntDomainVar[] vars) throws ContradictionException {
        ArrayList<IntDomainVar> res = new ArrayList<IntDomainVar>();
        double minValue = Double.POSITIVE_INFINITY;
        int n = this.solver.getNbIntVars();
        for (IntDomainVar v : vars) {
            if (v.isInstantiated()) continue;
            double val = this.getHeuristic(v);
            if (val < minValue) {
                res.clear();
                res.add(v);
                minValue = val;
                continue;
            }
            if (val != minValue) continue;
            res.add(v);
        }
        return res;
    }

    @Override
    public List<IntDomainVar> getAllMinVars(IntSConstraint c) throws ContradictionException {
        ArrayList<IntDomainVar> res = new ArrayList<IntDomainVar>();
        double minValue = Double.POSITIVE_INFINITY;
        for (int i = 0; i < c.getNbVars(); ++i) {
            IntDomainVar v = c.getIntVar(i);
            if (v.isInstantiated()) continue;
            double val = this.getHeuristic(v);
            if (val < minValue) {
                res.clear();
                res.add(v);
                minValue = val;
                continue;
            }
            if (val != minValue) continue;
            res.add(v);
        }
        return res;
    }

    @Override
    public IntDomainVar getMinVar(IntSConstraint c) throws ContradictionException {
        double minValue = Double.POSITIVE_INFINITY;
        IntDomainVar v0 = null;
        for (int i = 0; i < c.getNbVars(); ++i) {
            double val;
            IntDomainVar v = c.getIntVar(i);
            if (v.isInstantiated() || !((val = this.getHeuristic(c, i)) < minValue)) continue;
            minValue = val;
            v0 = v;
        }
        return v0;
    }
}

