/*
 * Decompiled with CFR 0.152.
 */
package choco.kernel.solver.search;

import choco.kernel.solver.Solution;
import choco.kernel.solver.Solver;
import choco.kernel.solver.search.AbstractOptimize;
import choco.kernel.solver.variables.integer.IntDomainVar;
import choco.kernel.solver.variables.real.RealVar;
import choco.kernel.solver.variables.set.SetVar;
import java.util.ArrayList;
import java.util.logging.Logger;

public abstract class AbstractSearchStrategy {
    public Solver solver;
    public ArrayList<Solution> solutions = new ArrayList();
    public int maxNbSolutionStored = 5;
    protected static Logger logger = Logger.getLogger("choco.kernel.solver.search");

    public Solver getSolver() {
        return this.solver;
    }

    public void setSolver(Solver solver) {
        this.solver = solver;
    }

    public void recordSolution() {
        Solution sol = this.solver.recordSolution();
        this.storeSolution(sol);
    }

    protected Solution makeSolutionFromCurrentState() {
        int nbv = this.solver.getNbIntVars();
        Solution sol = new Solution(this.solver);
        for (int i = 0; i < nbv; ++i) {
            IntDomainVar vari = (IntDomainVar)this.solver.getIntVar(i);
            if (!vari.isInstantiated()) continue;
            sol.recordIntValue(i, vari.getVal());
        }
        int nbsv = this.solver.getNbSetVars();
        for (int i = 0; i < nbsv; ++i) {
            SetVar vari = this.solver.getSetVar(i);
            if (!vari.isInstantiated()) continue;
            sol.recordSetValue(i, vari.getValue());
        }
        int nbrv = this.solver.getNbRealVars();
        for (int i = 0; i < nbrv; ++i) {
            RealVar vari = this.solver.getRealVar(i);
            sol.recordRealValue(i, vari.getValue());
        }
        if (this instanceof AbstractOptimize) {
            sol.recordIntObjective(((AbstractOptimize)this).getObjectiveValue());
        }
        return sol;
    }

    public void showSolution() {
        System.out.println(this.solver.pretty());
    }

    public void storeSolution(Solution sol) {
        if (this.solutions.size() == this.maxNbSolutionStored) {
            this.solutions.remove(this.solutions.size() - 1);
        }
        this.solutions.add(0, sol);
    }

    public boolean existsSolution() {
        return this.solutions.size() > 0;
    }

    protected Solution getBestSolution() {
        return this.existsSolution() ? this.solutions.get(0) : null;
    }

    public void restoreBestSolution() {
        this.solver.restoreSolution(this.getBestSolution());
    }

    public ArrayList<Solution> getStoredSolutions() {
        return this.solutions;
    }
}

