/*
 * Decompiled with CFR 0.152.
 */
package choco.kernel.solver.search;

import choco.kernel.common.util.Arithm;
import choco.kernel.solver.ContradictionException;
import choco.kernel.solver.search.AbstractGlobalSearchLimit;
import choco.kernel.solver.search.AbstractGlobalSearchStrategy;
import choco.kernel.solver.variables.integer.IntDomainVar;

public abstract class AbstractOptimize
extends AbstractGlobalSearchStrategy {
    public boolean doMaximize;
    public IntDomainVar objective;
    public int lowerBound = Integer.MIN_VALUE;
    public int upperBound = Integer.MAX_VALUE;
    public int targetUpperBound = Integer.MAX_VALUE;
    public int targetLowerBound = Integer.MIN_VALUE;

    protected AbstractOptimize(IntDomainVar obj, boolean maximize) {
        super(obj.getSolver());
        this.objective = obj;
        this.doMaximize = maximize;
    }

    public int getObjectiveValue() {
        if (this.doMaximize) {
            return this.objective.getSup();
        }
        return this.objective.getInf();
    }

    public int getBestObjectiveValue() {
        if (this.doMaximize) {
            return this.lowerBound;
        }
        return this.upperBound;
    }

    public int getObjectiveTarget() {
        if (this.doMaximize) {
            return this.targetLowerBound;
        }
        return this.targetUpperBound;
    }

    public void initBounds() {
        this.lowerBound = this.objective.getInf();
        this.upperBound = this.objective.getSup();
        this.targetLowerBound = this.objective.getInf();
        this.targetUpperBound = this.objective.getSup();
    }

    @Override
    public void recordSolution() {
        this.solver.setFeasible(Boolean.TRUE);
        StringBuffer b = new StringBuffer();
        b.append("... solution with cost ").append(this.objective).append(": ").append(this.objective.getVal()).append("   ");
        for (int i = 0; i < this.limits.size(); ++i) {
            AbstractGlobalSearchLimit lim = (AbstractGlobalSearchLimit)this.limits.get(i);
            b.append(lim.pretty()).append(" ");
        }
        logger.info(b.toString());
        this.setBound();
        this.setTargetBound();
        super.recordSolution();
    }

    public void setBound() {
        int objval = this.getObjectiveValue();
        if (this.doMaximize) {
            this.lowerBound = Arithm.max(this.lowerBound, objval);
        } else {
            this.upperBound = Arithm.min(this.upperBound, objval);
        }
    }

    public void setTargetBound() {
        if (this.doMaximize) {
            this.setTargetLowerBound();
        } else {
            this.setTargetUpperBound();
        }
    }

    protected void setTargetLowerBound() {
        int newBound = this.lowerBound + 1;
        if (this.solver.getFeasible() == Boolean.TRUE) {
            this.targetLowerBound = newBound;
        }
    }

    protected void setTargetUpperBound() {
        int newBound = this.upperBound - 1;
        if (this.solver.getFeasible() == Boolean.TRUE) {
            this.targetUpperBound = newBound;
        }
    }

    public void postTargetBound() throws ContradictionException {
        if (this.doMaximize) {
            this.postTargetLowerBound();
        } else {
            this.postTargetUpperBound();
        }
    }

    public void postTargetLowerBound() throws ContradictionException {
        this.objective.setInf(this.targetLowerBound);
    }

    public void postTargetUpperBound() throws ContradictionException {
        this.objective.setSup(this.targetUpperBound);
    }

    @Override
    public void postDynamicCut() throws ContradictionException {
        this.postTargetBound();
    }
}

