/*
 * Decompiled with CFR 0.152.
 */
package choco.kernel.solver.search;

import choco.kernel.solver.ContradictionException;
import choco.kernel.solver.Solver;
import choco.kernel.solver.SolverException;
import choco.kernel.solver.branch.AbstractBranching;
import choco.kernel.solver.branch.AbstractIntBranching;
import choco.kernel.solver.constraints.SConstraint;
import choco.kernel.solver.search.AbstractGlobalSearchLimit;
import choco.kernel.solver.search.AbstractSearchStrategy;
import choco.kernel.solver.search.GlobalSearchLimit;
import choco.kernel.solver.search.ISearchLoop;
import choco.kernel.solver.search.IntBranchingTrace;
import choco.kernel.solver.search.Limit;
import choco.kernel.solver.variables.integer.IntDomainVar;
import java.util.ArrayList;
import java.util.Collection;
import java.util.logging.Level;

public abstract class AbstractGlobalSearchStrategy
extends AbstractSearchStrategy {
    public static final int INIT_SEARCH = 0;
    public static final int OPEN_NODE = 1;
    public static final int UP_BRANCH = 2;
    public static final int DOWN_BRANCH = 4;
    public ArrayList<IntBranchingTrace> traceStack = null;
    public int currentTraceIndex = -1;
    public int nextMove = 0;
    public boolean stopAtFirstSol = true;
    protected GlobalSearchLimit encounteredLimit = null;
    public int nbSolutions = 0;
    protected int loggingMaxDepth = 5;
    public AbstractIntBranching mainGoal;
    public int baseWorld = 0;
    public ArrayList<AbstractGlobalSearchLimit> limits;
    public Collection<AbstractGlobalSearchLimit> solutionLimits;
    public ISearchLoop searchLoop;

    public void setLoggingMaxDepth(int loggingMaxDepth) {
        this.loggingMaxDepth = loggingMaxDepth;
    }

    public int getLoggingMaxDepth() {
        return this.loggingMaxDepth;
    }

    protected AbstractGlobalSearchStrategy(Solver solver) {
        this.solver = solver;
        this.limits = new ArrayList();
        this.traceStack = new ArrayList();
        this.currentTraceIndex = -1;
        this.nextMove = 0;
    }

    public void initMainGoal(SConstraint c) {
        if (this.mainGoal != null) {
            this.mainGoal.initConstraintForBranching(c);
            for (AbstractBranching branch = this.mainGoal.getNextBranching(); branch != null; branch = branch.getNextBranching()) {
                branch.initConstraintForBranching(c);
            }
        }
    }

    public void initializeDegreeOfVariables() {
        for (int i = 0; i < this.solver.getNbIntVars(); ++i) {
            IntDomainVar v = (IntDomainVar)this.solver.getIntVar(i);
            if (!v.isInstantiated()) continue;
            v.updateNbVarInstanciated();
        }
    }

    public void incrementalRun() {
        this.baseWorld = this.solver.getEnvironment().getWorldIndex();
        boolean feasibleRootState = true;
        try {
            this.newTreeSearch();
            this.solver.propagate();
        }
        catch (ContradictionException e) {
            feasibleRootState = false;
        }
        if (feasibleRootState) {
            this.solver.worldPush();
            if (this.stopAtFirstSol) {
                this.nextSolution();
            } else {
                while (this.nextSolution() == Boolean.TRUE) {
                }
            }
            if (this.maxNbSolutionStored > 0 && !this.stopAtFirstSol && this.existsSolution()) {
                this.solver.worldPopUntil(this.baseWorld);
                this.restoreBestSolution();
            }
            if (!this.isEncounteredLimit() && !this.existsSolution()) {
                this.solver.setFeasible(Boolean.FALSE);
            }
        } else {
            this.solver.setFeasible(Boolean.FALSE);
        }
        this.endTreeSearch();
    }

    public void newTreeSearch() throws ContradictionException {
        assert (this.solver.getSearchStrategy() == this);
        for (AbstractGlobalSearchLimit lim : this.limits) {
            lim.reset(true);
        }
        this.nbSolutions = 0;
        this.solutionLimits = null;
        this.baseWorld = this.solver.getEnvironment().getWorldIndex();
    }

    public void endTreeSearch() {
        if (logger.isLoggable(Level.SEVERE)) {
            if (this.solver.getFeasible() == Boolean.TRUE) {
                logger.log(Level.INFO, "solve => " + new Integer(this.nbSolutions) + " solutions");
            } else {
                logger.info("solve => no solution");
            }
            for (AbstractGlobalSearchLimit lim : this.limits) {
                logger.info(lim.pretty());
            }
        }
    }

    public void newTreeNode() throws ContradictionException {
        for (AbstractGlobalSearchLimit lim : this.limits) {
            if (lim.newNode(this)) continue;
            this.encounteredLimit = lim;
            this.solver.getPropagationEngine().raiseContradiction(lim, 4);
        }
    }

    public void endTreeNode() throws ContradictionException {
        for (AbstractGlobalSearchLimit lim : this.limits) {
            if (lim.endNode(this)) continue;
            this.encounteredLimit = lim;
            this.solver.getPropagationEngine().raiseContradiction(lim, 4);
        }
    }

    public Boolean nextSolution() {
        if (this.isEncounteredLimit()) {
            return null;
        }
        return this.searchLoop.run();
    }

    @Override
    public void recordSolution() {
        if (this.solver.checkDecisionVariables()) {
            this.solver.setFeasible(Boolean.TRUE);
            ++this.nbSolutions;
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("Solution #" + this.nbSolutions + " is found");
                if (logger.isLoggable(Level.FINER) && this.limits.size() > 0) {
                    StringBuffer sb = new StringBuffer("  with ");
                    for (AbstractGlobalSearchLimit lim : this.limits) {
                        sb.append(lim.pretty());
                        sb.append("; ");
                    }
                    logger.finer(sb.toString());
                }
                if (logger.isLoggable(Level.FINEST)) {
                    logger.finest("  " + this.solver.solutionToString());
                }
            }
            if (this.maxNbSolutionStored > 0) {
                super.recordSolution();
            }
        } else {
            throw new SolverException("Bug in solution :one or more decisions variables is not instantiated");
        }
    }

    @Override
    public void restoreBestSolution() {
        super.restoreBestSolution();
        this.solutionLimits = this.getBestSolution().getLimits();
    }

    public void postDynamicCut() throws ContradictionException {
    }

    public IntBranchingTrace pushTrace() {
        ++this.currentTraceIndex;
        IntBranchingTrace nextTrace = null;
        if (this.currentTraceIndex > this.traceStack.size() - 1) {
            nextTrace = new IntBranchingTrace();
            this.traceStack.add(nextTrace);
        } else {
            nextTrace = this.traceStack.get(this.currentTraceIndex);
            nextTrace.clear();
        }
        return nextTrace;
    }

    public IntBranchingTrace popTrace() {
        if (this.currentTraceIndex <= 0) {
            this.currentTraceIndex = -1;
            return null;
        }
        --this.currentTraceIndex;
        return this.traceStack.get(this.currentTraceIndex);
    }

    public IntBranchingTrace topTrace() {
        if (this.currentTraceIndex < 0) {
            return null;
        }
        return this.traceStack.get(this.currentTraceIndex);
    }

    public void popTraceUntil(int targetWorld) {
        while (this.currentTraceIndex > targetWorld) {
            this.popTrace();
        }
    }

    public void printRuntimeStatistics() {
        System.out.print(this.runtimeStatistics());
    }

    public String runtimeStatistics() {
        StringBuilder stb = new StringBuilder();
        for (AbstractGlobalSearchLimit l : this.limits) {
            stb.append(l.pretty()).append('\n');
        }
        return stb.toString();
    }

    public final AbstractGlobalSearchLimit getLimit(Limit limit) {
        for (AbstractGlobalSearchLimit l : this.limits) {
            if (!l.getType().getProperty().equals(limit.getProperty())) continue;
            return l;
        }
        return null;
    }

    private int getNb(AbstractGlobalSearchLimit limit) {
        return limit == null ? -1 : limit.getNbAll();
    }

    public int getTimeCount() {
        return this.getNb(this.getLimit(Limit.TIME));
    }

    public int getCpuTimeCount() {
        return this.getNb(this.getLimit(Limit.CPU_TIME));
    }

    public int getNodeCount() {
        return this.getNb(this.getLimit(Limit.NODE));
    }

    public int getBackTrackCount() {
        return this.getNb(this.getLimit(Limit.BACKTRACK));
    }

    public int getFailCount() {
        return this.getNb(this.getLimit(Limit.FAIL));
    }

    public boolean isEncounteredLimit() {
        return this.encounteredLimit != null;
    }

    public GlobalSearchLimit getEncounteredLimit() {
        return this.encounteredLimit;
    }

    public void setSearchLoop(ISearchLoop searchLoop) {
        this.searchLoop = searchLoop;
    }

    public void setEncounteredLimit(GlobalSearchLimit encounteredLimit) {
        this.encounteredLimit = encounteredLimit;
    }
}

