/*
 * Decompiled with CFR 0.152.
 */
package choco.kernel.solver.search;

import choco.kernel.solver.search.AbstractGlobalSearchStrategy;
import choco.kernel.solver.search.GlobalSearchLimit;
import choco.kernel.solver.search.Limit;

public abstract class AbstractGlobalSearchLimit
implements GlobalSearchLimit {
    protected final AbstractGlobalSearchStrategy strategy;
    protected final String unit;
    protected final Limit type;
    protected int nbMax = Integer.MAX_VALUE;
    protected int nb = 0;
    protected int nbTot = 0;

    public AbstractGlobalSearchLimit(AbstractGlobalSearchStrategy theStrategy, int theLimit, String unit) {
        this.strategy = theStrategy;
        this.nbMax = theLimit;
        this.type = null;
        this.unit = unit;
    }

    public AbstractGlobalSearchLimit(AbstractGlobalSearchStrategy theStrategy, int theLimit, Limit type) {
        this.strategy = theStrategy;
        this.nbMax = theLimit;
        this.type = type;
        this.unit = type.getUnit();
    }

    public String toString() {
        return this.getNbAll() + " " + this.unit;
    }

    @Override
    public void reset(boolean first) {
        this.nbTot = first ? 0 : (this.nbTot += this.nb);
        this.nb = 0;
    }

    @Override
    public String pretty() {
        String res = this.nbTot + "[+" + this.nb + "]";
        if (this.nbMax != Integer.MAX_VALUE) {
            res = res + "/" + this.nbMax;
        }
        return res + " " + this.unit;
    }

    public int getNb() {
        return this.nb;
    }

    public int getNbTot() {
        return this.nbTot;
    }

    public int getNbAll() {
        return this.getNb() + this.getNbTot();
    }

    public int getNbMax() {
        return this.nbMax;
    }

    public void setNbMax(int nbMax) {
        this.nbMax = nbMax;
    }

    public Limit getType() {
        return this.type;
    }

    public final AbstractGlobalSearchStrategy getStrategy() {
        return this.strategy;
    }
}

