/*
 * Decompiled with CFR 0.152.
 */
package choco.kernel.solver.propagation;

import choco.kernel.common.util.IPrioritizable;
import choco.kernel.solver.ContradictionException;
import choco.kernel.solver.Solver;
import choco.kernel.solver.propagation.PropagationEvent;
import choco.kernel.solver.variables.Var;
import java.util.logging.Logger;

public abstract class VarEvent<E extends Var>
implements PropagationEvent,
IPrioritizable {
    public static final int NOEVENT = -2;
    public static final int NOCAUSE = -1;
    protected int cause = -2;
    public static final int EMPTYEVENT = 0;
    protected E modifiedVar;
    protected static Logger logger = Logger.getLogger("choco.kernel.solver.propagation");
    protected int eventType = 0;
    protected int propagatedEvents = 0;

    public VarEvent(E var) {
        this.modifiedVar = var;
    }

    public void addPropagatedEvents(int bitsmask) {
        this.propagatedEvents |= bitsmask;
    }

    public int getPropagatedEvents() {
        return this.propagatedEvents;
    }

    public E getModifiedVar() {
        return this.modifiedVar;
    }

    @Override
    public Object getModifiedObject() {
        return this.modifiedVar;
    }

    protected void freeze() {
        this.cause = -2;
    }

    protected boolean release() {
        boolean anyUpdateSinceFreeze = this.cause != -2;
        return anyUpdateSinceFreeze;
    }

    @Override
    public abstract boolean propagateEvent() throws ContradictionException;

    @Override
    public abstract void clear();

    @Override
    public boolean isActive(int idx) {
        return true;
    }

    public Solver getSolver() {
        return this.modifiedVar.getSolver();
    }

    public int getCause() {
        return this.cause;
    }

    @Override
    public int getPriority() {
        return 0;
    }

    public int getEventType() {
        return this.eventType;
    }

    public boolean isEnqueued() {
        return this.eventType != 0;
    }

    public void recordEventTypeAndCause(int basicEvt, int idx) {
        if (this.cause == -2 || this.eventType == 0) {
            this.eventType = 1 << basicEvt;
            this.cause = idx;
        } else {
            this.eventType |= 1 << basicEvt;
            if (this.cause != idx) {
                this.cause = -1;
            }
        }
    }
}

