/*
 * Decompiled with CFR 0.152.
 */
package choco.kernel.solver.propagation;

import choco.kernel.common.util.BipartiteSet;
import choco.kernel.solver.ContradictionException;
import choco.kernel.solver.propagation.ConstraintEvent;
import choco.kernel.solver.propagation.EventQueue;
import choco.kernel.solver.propagation.PropagationEngine;
import choco.kernel.solver.propagation.PropagationEvent;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ConstraintEventQueue
implements EventQueue {
    private PropagationEngine engine;
    private BipartiteSet<PropagationEvent> partition;
    private static Logger logger = Logger.getLogger("choco.kernel.solver.propagation");

    public ConstraintEventQueue(PropagationEngine engine) {
        this.engine = engine;
        this.partition = new BipartiteSet();
    }

    @Override
    public boolean isEmpty() {
        return this.partition.getNbLeft() == 0;
    }

    @Override
    public PropagationEvent popEvent() {
        PropagationEvent event = this.partition.moveLastLeft();
        if (event == null) {
            if (logger.isLoggable(Level.SEVERE)) {
                logger.severe("Error: There is no more events in the queue.");
            }
        } else if (!((ConstraintEvent)event).isInitialized()) {
            this.engine.decPendingInitConstAwakeEvent();
        }
        return event;
    }

    @Override
    public boolean pushEvent(PropagationEvent event) {
        if (!this.partition.isLeft(event)) {
            this.partition.moveLeft(event);
            return true;
        }
        return false;
    }

    @Override
    public void flushEventQueue() {
        this.partition.moveAllRight();
    }

    public void add(PropagationEvent event) {
        if (this.partition.isIn(event)) {
            this.partition.moveRight(event);
        } else {
            this.partition.addRight(event);
        }
    }

    @Override
    public void remove(PropagationEvent event) {
        if (this.partition.isLeft(event)) {
            if (!((ConstraintEvent)event).isInitialized()) {
                this.engine.decPendingInitConstAwakeEvent();
            }
            this.partition.moveRight(event);
        }
    }

    @Override
    public void propagateSomeEvents() throws ContradictionException {
        PropagationEvent evt = this.popEvent();
        evt.propagateEvent();
    }

    @Override
    public void propagateOneEvent() throws ContradictionException {
        this.popEvent().propagateEvent();
    }

    @Override
    public int size() {
        return this.partition.getNbLeft();
    }

    @Override
    public PropagationEvent get(int idx) {
        Iterator<PropagationEvent> it = this.partition.leftIterator();
        while (it.hasNext()) {
            PropagationEvent event = it.next();
            if (idx == 0) {
                return event;
            }
            --idx;
        }
        return null;
    }
}

