/*
 * Decompiled with CFR 0.152.
 */
package choco.kernel.solver.propagation;

import choco.Choco;
import choco.kernel.solver.ContradictionException;
import choco.kernel.solver.propagation.PropagationEvent;
import choco.kernel.solver.propagation.Propagator;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ConstraintEvent
implements PropagationEvent {
    public static final int HIGH = 0;
    public static final int MEDIUM = 1;
    public static final int LOW = 2;
    public static final int nbpriority = 3;
    private Propagator touchedConstraint;
    private boolean initialized = false;
    private int priority = -1;
    private static Logger logger = Logger.getLogger("choco.kernel.solver.propagation");

    public ConstraintEvent(Propagator constraint, boolean init, int prio) {
        this.touchedConstraint = constraint;
        this.initialized = init;
        this.priority = prio;
    }

    @Override
    public Object getModifiedObject() {
        return this.touchedConstraint;
    }

    public int getPriority() {
        return this.priority;
    }

    @Override
    public boolean propagateEvent() throws ContradictionException {
        if (this.initialized) {
            if (Choco.DEBUG && !this.touchedConstraint.isActive()) {
                System.err.println("There should not be some not active constraint events in the queue !");
            }
            this.touchedConstraint.propagate();
        } else {
            this.touchedConstraint.awake();
            this.touchedConstraint.setActiveSilently();
        }
        return true;
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    public void setInitialized(boolean init) {
        this.initialized = init;
    }

    @Override
    public boolean isActive(int idx) {
        return true;
    }

    @Override
    public void clear() {
        if (logger.isLoggable(Level.WARNING)) {
            logger.warning("Const Awake Event does not need to be cleared !");
        }
    }
}

