/*
 * Decompiled with CFR 0.152.
 */
package choco.kernel.solver.goals.solver;

import choco.kernel.solver.ContradictionException;
import choco.kernel.solver.Solver;
import choco.kernel.solver.goals.Goal;

public class ChoicePoint
implements Goal {
    protected Goal[] choices;

    public ChoicePoint(Goal[] goals) {
        this.choices = goals;
    }

    @Override
    public String pretty() {
        StringBuilder sb = new StringBuilder();
        sb.append("or(");
        for (int i = 0; i < this.choices.length; ++i) {
            if (i > 0) {
                sb.append(", ");
            }
            Goal goal = this.choices[i];
            sb.append(goal.pretty());
        }
        sb.append(")");
        return sb.toString();
    }

    @Override
    public Goal execute(Solver solver) throws ContradictionException {
        System.err.println("Should not be called in ChoicePoint !!");
        return null;
    }

    public Goal getChoice(int choiceIndex) {
        return this.choices[choiceIndex];
    }

    public int getNbChoices() {
        return this.choices.length;
    }
}

