/*
 * Decompiled with CFR 0.152.
 */
package choco.kernel.solver.constraints.set;

import choco.kernel.solver.SolverException;
import choco.kernel.solver.constraints.set.AbstractSetSConstraint;
import choco.kernel.solver.variables.Var;
import choco.kernel.solver.variables.set.SetVar;

public abstract class AbstractTernSetSConstraint
extends AbstractSetSConstraint {
    public SetVar v0;
    public SetVar v1;
    public SetVar v2;
    public int cIdx0;
    public int cIdx1;
    public int cIdx2;

    protected AbstractTernSetSConstraint(SetVar v0, SetVar v1, SetVar v2) {
        this.v0 = v0;
        this.v1 = v1;
        this.v2 = v2;
    }

    @Override
    public void setConstraintIndex(int i, int val) {
        if (i == 0) {
            this.cIdx0 = val;
        } else if (i == 1) {
            this.cIdx1 = val;
        } else if (i == 2) {
            this.cIdx2 = val;
        } else {
            throw new SolverException("bug in setConstraintIndex i:" + i + " this: " + this);
        }
    }

    @Override
    public int getConstraintIdx(int idx) {
        if (idx == 0) {
            return this.cIdx0;
        }
        if (idx == 1) {
            return this.cIdx1;
        }
        if (idx == 2) {
            return this.cIdx2;
        }
        return -1;
    }

    @Override
    public boolean isCompletelyInstantiated() {
        return this.v0.isInstantiated() && this.v1.isInstantiated() && this.v2.isInstantiated();
    }

    @Override
    public int getNbVars() {
        return 3;
    }

    @Override
    public Var getVar(int i) {
        if (i == 0) {
            return this.v0;
        }
        if (i == 1) {
            return this.v1;
        }
        if (i == 2) {
            return this.v2;
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void setVar(int i, Var v) {
        if (!(v instanceof SetVar)) throw new SolverException("BUG in CSP network management: wrong type of Var for setVar");
        if (i == 0) {
            this.v0 = (SetVar)v;
            return;
        } else if (i == 1) {
            this.v1 = (SetVar)v;
            return;
        } else {
            if (i != 2) throw new SolverException("BUG in CSP network management: too large index for setVar");
            this.v2 = (SetVar)v;
        }
    }

    @Override
    public SetVar getSetVar(int i) {
        if (i == 0) {
            return this.v0;
        }
        if (i == 1) {
            return this.v1;
        }
        if (i == 2) {
            return this.v2;
        }
        return null;
    }
}

