/*
 * Decompiled with CFR 0.152.
 */
package choco.kernel.solver.constraints.set;

import choco.kernel.common.util.IntIterator;
import choco.kernel.solver.ContradictionException;
import choco.kernel.solver.Solver;
import choco.kernel.solver.SolverException;
import choco.kernel.solver.constraints.AbstractSConstraint;
import choco.kernel.solver.constraints.SConstraintType;
import choco.kernel.solver.constraints.set.SetSConstraint;
import java.util.logging.Logger;

public abstract class AbstractSetSConstraint
extends AbstractSConstraint
implements SetSConstraint {
    protected static Logger logger = Logger.getLogger("choco.kernel.solver.propagation.const");

    @Override
    public void awakeOnKer(int varIdx, int x) throws ContradictionException {
        this.propagate();
    }

    @Override
    public void awakeOnEnv(int varIdx, int x) throws ContradictionException {
        this.propagate();
    }

    @Override
    public void awakeOnInst(int varIdx) throws ContradictionException {
        this.propagate();
    }

    @Override
    public void awakeOnEnvRemovals(int idx, IntIterator deltaDomain) throws ContradictionException {
        if (deltaDomain != null) {
            while (deltaDomain.hasNext()) {
                int val = deltaDomain.next();
                this.awakeOnEnv(idx, val);
            }
        } else {
            throw new SolverException("deltaDomain should not be null in awakeOnEnvRemovals");
        }
    }

    @Override
    public void awakeOnkerAdditions(int idx, IntIterator deltaDomain) throws ContradictionException {
        if (deltaDomain != null) {
            while (deltaDomain.hasNext()) {
                int val = deltaDomain.next();
                this.awakeOnKer(idx, val);
            }
        } else {
            throw new SolverException("deltaDomain should not be null in awakeOnKerAdditions");
        }
    }

    @Override
    public boolean isCompletelyInstantiated() {
        int n = this.getNbVars();
        for (int i = 0; i < n; ++i) {
            if (this.getSetVar(i).isInstantiated()) continue;
            return false;
        }
        return true;
    }

    public int getSelfIndex() {
        Solver solver = this.getSolver();
        for (int i = 0; i < solver.getNbIntConstraints(); ++i) {
            Object c = null;
            if (c != this) continue;
            return i;
        }
        return -1;
    }

    @Override
    public SConstraintType getConstraintType() {
        return SConstraintType.SET;
    }

    @Override
    public int getFineDegree(int idx) {
        return 1;
    }
}

