/*
 * Decompiled with CFR 0.152.
 */
package choco.kernel.solver.constraints.set;

import choco.kernel.solver.SolverException;
import choco.kernel.solver.constraints.set.AbstractSetSConstraint;
import choco.kernel.solver.variables.Var;
import choco.kernel.solver.variables.set.SetVar;

public abstract class AbstractLargeSetSConstraint
extends AbstractSetSConstraint {
    public SetVar[] vars;
    public int[] cIndices;

    public AbstractLargeSetSConstraint(SetVar[] vars) {
        this.vars = new SetVar[vars.length];
        System.arraycopy(vars, 0, this.vars, 0, vars.length);
        this.cIndices = new int[vars.length];
    }

    @Override
    public void setConstraintIndex(int i, int val) {
        if (i < 0 || i >= this.vars.length) {
            throw new SolverException("bug in setConstraintIndex i:" + i + " this: " + this);
        }
        this.cIndices[i] = val;
    }

    @Override
    public int getConstraintIdx(int idx) {
        if (idx >= 0 && idx < this.vars.length) {
            return this.cIndices[idx];
        }
        return -1;
    }

    @Override
    public boolean isCompletelyInstantiated() {
        for (SetVar var : this.vars) {
            if (var.isInstantiated()) continue;
            return false;
        }
        return true;
    }

    @Override
    public int getNbVars() {
        return this.vars.length;
    }

    @Override
    public Var getVar(int i) {
        if (i >= 0 && i < this.vars.length) {
            return this.vars[i];
        }
        return null;
    }

    @Override
    public void setVar(int i, Var v) {
        if (v instanceof SetVar) {
            if (i < 0 || i >= this.vars.length) {
                throw new SolverException("BUG in CSP network management: too large index for setVar");
            }
        } else {
            throw new SolverException("BUG in CSP network management: wrong type of Var for setVar");
        }
        this.vars[i] = (SetVar)v;
    }

    @Override
    public SetVar getSetVar(int i) {
        if (i >= 0 && i < this.vars.length) {
            return this.vars[i];
        }
        return null;
    }
}

