/*
 * Decompiled with CFR 0.152.
 */
package choco.kernel.solver.constraints.set;

import choco.kernel.solver.SolverException;
import choco.kernel.solver.constraints.set.AbstractMixedSConstraint;
import choco.kernel.solver.variables.Var;
import choco.kernel.solver.variables.integer.IntDomainVar;
import choco.kernel.solver.variables.integer.IntVar;
import choco.kernel.solver.variables.set.SetVar;

public abstract class AbstractLargeSetIntSConstraint
extends AbstractMixedSConstraint {
    public SetVar[] svars;
    public IntDomainVar[] ivars;
    public int nbvar;
    public int[] set_cIndices;
    public int[] int_cIndices;

    public AbstractLargeSetIntSConstraint(int nbSetVar, int nbIntVar) {
        this.svars = new SetVar[nbSetVar];
        this.set_cIndices = new int[nbSetVar];
        this.ivars = new IntDomainVar[nbIntVar];
        this.int_cIndices = new int[nbIntVar];
        this.nbvar = nbSetVar + nbIntVar;
    }

    public AbstractLargeSetIntSConstraint(IntVar[] intvars, SetVar[] setvars) {
        this.ivars = new IntDomainVar[intvars.length];
        System.arraycopy(intvars, 0, this.ivars, 0, intvars.length);
        this.int_cIndices = new int[intvars.length];
        this.svars = new SetVar[setvars.length];
        System.arraycopy(setvars, 0, this.svars, 0, setvars.length);
        this.set_cIndices = new int[setvars.length];
        this.nbvar = intvars.length + setvars.length;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void setConstraintIndex(int i, int val) {
        if (i < 0) throw new SolverException("bug in SetIntConstraintIndex i:" + i + " this: " + this);
        if (i < this.svars.length) {
            this.set_cIndices[i] = val;
            return;
        } else {
            if (i >= this.nbvar) throw new SolverException("bug in SetIntConstraintIndex i:" + i + " this: " + this);
            this.int_cIndices[i - this.svars.length] = val;
        }
    }

    @Override
    public int getConstraintIdx(int idx) {
        if (idx >= 0) {
            if (idx < this.svars.length) {
                return this.set_cIndices[idx];
            }
            if (idx < this.nbvar) {
                return this.int_cIndices[idx - this.svars.length];
            }
            return -1;
        }
        return -1;
    }

    @Override
    public boolean isCompletelyInstantiated() {
        for (SetVar setVar : this.svars) {
            if (setVar.isInstantiated()) continue;
            return false;
        }
        for (Var var : this.ivars) {
            if (var.isInstantiated()) continue;
            return false;
        }
        return true;
    }

    @Override
    public int getNbVars() {
        return this.nbvar;
    }

    @Override
    public SetVar getSetVar(int i) {
        if (i >= 0 && i < this.svars.length) {
            return this.svars[i];
        }
        return null;
    }

    @Override
    public IntDomainVar getIntVar(int i) {
        if (i >= 0 && i < this.ivars.length) {
            return this.ivars[i];
        }
        return null;
    }

    @Override
    public Var getVar(int i) {
        if (i >= 0) {
            if (i < this.svars.length) {
                return this.svars[i];
            }
            if (i < this.nbvar) {
                return this.ivars[i - this.svars.length];
            }
            return null;
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void setVar(int i, Var v) {
        if (i < 0) throw new SolverException("BUG in CSP network management: negative index for set/int Var");
        if (i < this.svars.length) {
            this.svars[i] = (SetVar)v;
            return;
        } else {
            if (i >= this.nbvar) throw new SolverException("BUG in CSP network management: too large index for set/int Var");
            this.ivars[i - this.svars.length] = (IntDomainVar)v;
        }
    }
}

