/*
 * Decompiled with CFR 0.152.
 */
package choco.kernel.solver.constraints.set;

import choco.kernel.solver.SolverException;
import choco.kernel.solver.constraints.set.AbstractMixedSConstraint;
import choco.kernel.solver.variables.Var;
import choco.kernel.solver.variables.integer.IntDomainVar;
import choco.kernel.solver.variables.set.SetVar;

public abstract class AbstractBinSetIntSConstraint
extends AbstractMixedSConstraint {
    public IntDomainVar v0;
    public SetVar v1;
    public int cIdx0;
    public int cIdx1;

    public AbstractBinSetIntSConstraint(IntDomainVar X, SetVar S) {
        this.v0 = X;
        this.v1 = S;
    }

    @Override
    public void setConstraintIndex(int i, int val) {
        if (i == 0) {
            this.cIdx0 = val;
        } else if (i == 1) {
            this.cIdx1 = val;
        } else {
            throw new SolverException("bug in setConstraintIndex i:" + i + " this: " + this);
        }
    }

    @Override
    public int getConstraintIdx(int idx) {
        if (idx == 0) {
            return this.cIdx0;
        }
        if (idx == 1) {
            return this.cIdx1;
        }
        return -1;
    }

    @Override
    public boolean isCompletelyInstantiated() {
        return this.v0.isInstantiated() && this.v1.isInstantiated();
    }

    @Override
    public int getNbVars() {
        return 2;
    }

    @Override
    public Var getVar(int i) {
        if (i == 0) {
            return this.v0;
        }
        if (i == 1) {
            return this.v1;
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void setVar(int i, Var v) {
        if (i == 0) {
            if (!(v instanceof IntDomainVar)) throw new SolverException("BUG in CSP network management: wrong type of Var for setVar");
            this.v0 = (IntDomainVar)v;
            return;
        } else {
            if (i != 1) throw new SolverException("BUG in CSP network management: too large index for setVar");
            if (!(v instanceof SetVar)) throw new SolverException("BUG in CSP network management: wrong type of Var for setVar");
            this.v1 = (SetVar)v;
        }
    }

    @Override
    public IntDomainVar getIntVar(int i) {
        if (i == 0) {
            return this.v0;
        }
        return null;
    }

    @Override
    public SetVar getSetVar(int i) {
        if (i == 1) {
            return this.v1;
        }
        return null;
    }
}

