/*
 * Decompiled with CFR 0.152.
 */
package choco.kernel.solver.constraints.reified;

import choco.IPretty;
import choco.kernel.model.variables.integer.IntegerVariable;
import choco.kernel.solver.Solver;
import choco.kernel.solver.constraints.reified.NodeType;
import choco.kernel.solver.variables.integer.IntDomainVar;
import gnu.trove.TIntArrayList;
import java.util.HashSet;

public abstract class INode
implements IPretty {
    protected INode[] subtrees;
    private final NodeType type;

    public INode(NodeType type) {
        this.type = type;
    }

    public INode(INode[] subt, NodeType type) {
        this(type);
        this.subtrees = subt;
    }

    public int getNbSubTrees() {
        return this.subtrees.length;
    }

    public INode getSubtree(int i) {
        return this.subtrees[i];
    }

    public IntDomainVar[] getScope(Solver s) {
        if (this.subtrees == null) {
            return null;
        }
        if (this.subtrees.length == 1) {
            return this.subtrees[0].getScope(s);
        }
        IntDomainVar[] vars = this.union(this.subtrees[0].getScope(s), this.subtrees[1].getScope(s));
        for (int i = 2; i < this.subtrees.length; ++i) {
            vars = this.union(vars, this.subtrees[i].getScope(s));
        }
        return vars;
    }

    public IntegerVariable[] getModelScope() {
        if (this.subtrees == null) {
            return null;
        }
        if (this.subtrees.length == 1) {
            return this.subtrees[0].getModelScope();
        }
        IntegerVariable[] vars = this.union(this.subtrees[0].getModelScope(), this.subtrees[1].getModelScope());
        for (int i = 2; i < this.subtrees.length; ++i) {
            vars = this.union(vars, this.subtrees[i].getModelScope());
        }
        return vars;
    }

    public void setIndexes(IntDomainVar[] vs) {
        if (this.subtrees != null) {
            for (int i = 0; i < this.subtrees.length; ++i) {
                this.subtrees[i].setIndexes(vs);
            }
        }
    }

    public IntDomainVar[] union(IntDomainVar[] t1, IntDomainVar[] t2) {
        int i;
        TIntArrayList indexes = new TIntArrayList();
        IntDomainVar[] unionset = new IntDomainVar[(t1 == null ? 0 : t1.length) + (t2 == null ? 0 : t2.length)];
        int indice = 0;
        for (i = 0; t1 != null && i < t1.length; ++i) {
            if (t1[i] == null || indexes.contains(t1[i].getIndexIn(0))) continue;
            indexes.add(t1[i].getIndexIn(0));
            unionset[indice++] = t1[i];
        }
        for (i = 0; t2 != null && i < t2.length; ++i) {
            if (t2[i] == null || indexes.contains(t2[i].getIndexIn(0))) continue;
            indexes.add(t2[i].getIndexIn(0));
            unionset[indice++] = t2[i];
        }
        IntDomainVar[] uniontab = new IntDomainVar[indice];
        System.arraycopy(unionset, 0, uniontab, 0, indice);
        return uniontab;
    }

    public IntegerVariable[] union(IntegerVariable[] t1, IntegerVariable[] t2) {
        int i;
        HashSet<IntegerVariable> unionset = new HashSet<IntegerVariable>();
        for (i = 0; t1 != null && i < t1.length; ++i) {
            if (unionset.contains(t1[i])) continue;
            unionset.add(t1[i]);
        }
        for (i = 0; t2 != null && i < t2.length; ++i) {
            if (unionset.contains(t2[i])) continue;
            unionset.add(t2[i]);
        }
        IntegerVariable[] uniontab = new IntegerVariable[unionset.size()];
        unionset.toArray(uniontab);
        return uniontab;
    }

    public IntDomainVar extractResult(Solver s) {
        return null;
    }

    public boolean isDecompositionPossible() {
        if (this.subtrees == null) {
            return true;
        }
        for (int i = 0; i < this.subtrees.length; ++i) {
            if (this.subtrees[i].isDecompositionPossible()) continue;
            return false;
        }
        return true;
    }

    public boolean isReified() {
        if (this.subtrees == null) {
            return false;
        }
        for (int i = 0; i < this.subtrees.length; ++i) {
            if (!this.subtrees[i].isReified()) continue;
            return true;
        }
        return false;
    }

    public boolean hasOnlyVariablesLeaves() {
        for (int i = 0; i < this.subtrees.length; ++i) {
            if (this.subtrees[i].isAVariable()) continue;
            return false;
        }
        return true;
    }

    public int countNbVar() {
        int cv = 0;
        for (int i = 0; i < this.subtrees.length; ++i) {
            cv += this.subtrees[i].countNbVar();
        }
        return cv;
    }

    public boolean isAVariable() {
        return false;
    }

    public boolean isCsteEqualTo(int a) {
        return false;
    }

    public boolean isAConstant() {
        for (int i = 0; i < this.subtrees.length; ++i) {
            if (this.subtrees[i].isAConstant()) continue;
            return false;
        }
        return true;
    }

    public boolean isALinearTerm() {
        return false;
    }

    public int[] computeLinearExpr(int scope) {
        return null;
    }

    public NodeType getType() {
        return this.type;
    }
}

