/*
 * Decompiled with CFR 0.152.
 */
package choco.kernel.solver.constraints.real.exp;

import choco.kernel.memory.IEnvironment;
import choco.kernel.memory.IStateDouble;
import choco.kernel.solver.ContradictionException;
import choco.kernel.solver.Solver;
import choco.kernel.solver.constraints.real.RealExp;
import choco.kernel.solver.variables.real.RealInterval;

public abstract class AbstractRealCompoundTerm
implements RealExp {
    protected IStateDouble inf;
    protected IStateDouble sup;
    public Solver solver;

    public AbstractRealCompoundTerm(Solver solver) {
        this.solver = solver;
        IEnvironment env = solver.getEnvironment();
        this.inf = env.makeFloat(Double.NEGATIVE_INFINITY);
        this.sup = env.makeFloat(Double.POSITIVE_INFINITY);
    }

    @Override
    public Solver getSolver() {
        return this.solver;
    }

    @Override
    public void setSolver(Solver solver) {
        this.solver = solver;
    }

    public String toString() {
        return "[" + this.inf.get() + "," + this.sup.get() + "]";
    }

    @Override
    public double getInf() {
        return this.inf.get();
    }

    @Override
    public double getSup() {
        return this.sup.get();
    }

    @Override
    public void intersect(RealInterval interval) throws ContradictionException {
        this.intersect(interval, -1);
    }

    @Override
    public void intersect(RealInterval interval, int index) throws ContradictionException {
        if (interval.getInf() > this.inf.get()) {
            this.inf.set(interval.getInf());
        }
        if (interval.getSup() < this.sup.get()) {
            this.sup.set(interval.getSup());
        }
        if (this.inf.get() > this.sup.get()) {
            this.solver.getPropagationEngine().raiseContradiction(this, 3);
        }
    }

    @Override
    public String pretty() {
        return this.toString();
    }
}

