/*
 * Decompiled with CFR 0.152.
 */
package choco.kernel.solver.constraints.real;

import choco.kernel.solver.SolverException;
import choco.kernel.solver.constraints.AbstractSConstraint;
import choco.kernel.solver.constraints.SConstraintType;
import choco.kernel.solver.constraints.real.RealSConstraint;
import choco.kernel.solver.variables.Var;
import choco.kernel.solver.variables.real.RealVar;

public abstract class AbstractLargeRealSConstraint
extends AbstractSConstraint
implements RealSConstraint {
    protected RealVar[] vars;
    protected int[] cIndices;

    public AbstractLargeRealSConstraint(RealVar[] vars) {
        this.vars = new RealVar[vars.length];
        System.arraycopy(vars, 0, this.vars, 0, vars.length);
        this.cIndices = new int[vars.length];
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        AbstractLargeRealSConstraint newc = (AbstractLargeRealSConstraint)super.clone();
        newc.vars = new RealVar[this.vars.length];
        System.arraycopy(this.vars, 0, newc.vars, 0, this.vars.length);
        this.cIndices = new int[this.cIndices.length];
        System.arraycopy(this.cIndices, 0, newc.cIndices, 0, this.cIndices.length);
        return newc;
    }

    @Override
    public void setConstraintIndex(int i, int idx) {
        if (i < 0 || i >= this.vars.length) {
            throw new SolverException("bug in setConstraintIndex i:" + i + " this: " + this);
        }
        this.cIndices[i] = idx;
    }

    @Override
    public int getConstraintIdx(int i) {
        if (i >= 0 && i < this.vars.length) {
            return this.cIndices[i];
        }
        return -1;
    }

    @Override
    public int getNbVars() {
        return this.vars.length;
    }

    @Override
    public Var getVar(int i) {
        if (0 <= i && i < this.vars.length) {
            return this.vars[i];
        }
        return null;
    }

    @Override
    public void setVar(int i, Var v) {
        if (v instanceof RealVar) {
            if (i < 0 || i >= this.vars.length) {
                throw new SolverException("BUG in CSP network management: too large index for setVar");
            }
        } else {
            throw new SolverException("BUG in CSP network management: wrong type of Var for setVar");
        }
        this.vars[i] = (RealVar)v;
    }

    @Override
    public RealVar getRealVar(int i) {
        if (0 <= i && i < this.vars.length) {
            return this.vars[i];
        }
        return null;
    }

    @Override
    public int getRealVarNb() {
        return this.vars.length;
    }

    @Override
    public boolean isCompletelyInstantiated() {
        int nVariables = this.vars.length;
        for (int i = 0; i < nVariables; ++i) {
            if (this.vars[i].isInstantiated()) continue;
            return false;
        }
        return true;
    }

    public int getSelfIndex() {
        return 0;
    }

    @Override
    public SConstraintType getConstraintType() {
        return SConstraintType.REAL;
    }

    @Override
    public int getFineDegree(int idx) {
        return 1;
    }
}

