/*
 * Decompiled with CFR 0.152.
 */
package choco.kernel.solver.constraints.real;

import choco.kernel.solver.SolverException;
import choco.kernel.solver.constraints.AbstractSConstraint;
import choco.kernel.solver.constraints.SConstraintType;
import choco.kernel.solver.variables.Var;
import choco.kernel.solver.variables.integer.IntDomainVar;
import choco.kernel.solver.variables.real.RealVar;

public abstract class AbstractBinRealIntSConstraint
extends AbstractSConstraint {
    protected RealVar v0;
    protected int cIdx0;
    protected IntDomainVar v1;
    protected int cIdx1;

    public AbstractBinRealIntSConstraint(RealVar v0, IntDomainVar v1) {
        this.v0 = v0;
        this.v1 = v1;
        this.solver = v0.getSolver();
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public RealVar getRealVar(int i) {
        if (i == 0) {
            return this.v0;
        }
        return null;
    }

    public int getRealVarNb() {
        return 1;
    }

    public IntDomainVar getIntVar(int i) {
        if (i == 0) {
            return this.v1;
        }
        return null;
    }

    public int getIntVarNb() {
        return 1;
    }

    @Override
    public int getNbVars() {
        return 2;
    }

    @Override
    public Var getVar(int i) {
        if (i == 0) {
            return this.v0;
        }
        if (i == 1) {
            return this.v1;
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void setVar(int i, Var v) {
        if (i == 0) {
            if (!(v instanceof RealVar)) throw new SolverException("BUG in CSP network management: wrong type of Var for setVar");
            this.v0 = (RealVar)v;
            return;
        } else {
            if (i != 1) throw new SolverException("BUG in CSP network management: too large index for setVar");
            if (!(v instanceof IntDomainVar)) throw new SolverException("BUG in CSP network management: wrong type of Var for setVar");
            this.v1 = (IntDomainVar)v;
        }
    }

    @Override
    public void setConstraintIndex(int i, int idx) {
        if (i == 0) {
            this.cIdx0 = idx;
        } else if (i == 1) {
            this.cIdx1 = idx;
        } else {
            throw new SolverException("bug in setConstraintIndex i:" + i + " this: " + this);
        }
    }

    @Override
    public int getConstraintIdx(int idx) {
        if (idx == 0) {
            return this.cIdx0;
        }
        if (idx == 1) {
            return this.cIdx1;
        }
        return -1;
    }

    @Override
    public boolean isCompletelyInstantiated() {
        return this.v1.isInstantiated() && this.v0.isInstantiated();
    }

    public boolean isSatisfied(int[] tuple) {
        throw new UnsupportedOperationException(this + " needs to implement isSatisfied(int[] tuple) to be embedded in reified constraints");
    }

    @Override
    public SConstraintType getConstraintType() {
        return SConstraintType.INT_REAL;
    }
}

