/*
 * Decompiled with CFR 0.152.
 */
package choco.kernel.solver.constraints.integer.extension;

import choco.kernel.solver.constraints.integer.extension.ConsistencyRelation;
import choco.kernel.solver.constraints.integer.extension.LargeRelation;
import java.util.BitSet;

public class TuplesTable
extends ConsistencyRelation
implements LargeRelation {
    protected int n;
    protected BitSet table;
    protected int[] offsets;
    protected int[] sizes;
    protected int[] blocks;

    public TuplesTable(int n) {
        this.n = n;
    }

    public TuplesTable(boolean feas, int[] offsetTable, int[] sizesTable) {
        this.offsets = offsetTable;
        this.sizes = sizesTable;
        this.n = offsetTable.length;
        this.feasible = feas;
        int totalSize = 1;
        this.blocks = new int[this.n];
        for (int i = 0; i < this.n; ++i) {
            this.blocks[i] = totalSize;
            totalSize *= this.sizes[i];
        }
        if (totalSize / 8 > 0x3200000) {
            System.out.println("Tuples requiered over 50Mo of memory...");
        }
        this.table = totalSize < 0 ? new BitSet() : new BitSet(totalSize);
    }

    @Override
    public boolean checkTuple(int[] tuple) {
        int address = 0;
        for (int i = this.n - 1; i >= 0; --i) {
            if (tuple[i] < this.offsets[i] || tuple[i] > this.offsets[i] + this.sizes[i] - 1) {
                return false;
            }
            address += (tuple[i] - this.offsets[i]) * this.blocks[i];
        }
        return this.table.get(address);
    }

    @Override
    public boolean isConsistent(int[] tuple) {
        return this.checkTuple(tuple) == this.feasible;
    }

    public void setTuple(int[] tuple) {
        int address = 0;
        for (int i = this.n - 1; i >= 0; --i) {
            address += (tuple[i] - this.offsets[i]) * this.blocks[i];
        }
        this.table.set(address);
    }

    @Override
    public ConsistencyRelation getOpposite() {
        TuplesTable t = new TuplesTable(this.n);
        t.feasible = !this.feasible;
        t.offsets = this.offsets;
        t.sizes = this.sizes;
        t.blocks = this.blocks;
        t.table = this.table;
        return t;
    }
}

