/*
 * Decompiled with CFR 0.152.
 */
package choco.kernel.solver.constraints.integer.extension;

import choco.kernel.common.util.DisposableIntIterator;
import choco.kernel.solver.constraints.integer.AbstractBinIntSConstraint;
import choco.kernel.solver.constraints.integer.extension.BinRelation;
import choco.kernel.solver.variables.integer.IntDomainVar;

public abstract class CspBinSConstraint
extends AbstractBinIntSConstraint {
    protected BinRelation relation;

    protected CspBinSConstraint(IntDomainVar x, IntDomainVar y, BinRelation relation) {
        super(x, y);
        this.relation = relation;
    }

    @Override
    public boolean isSatisfied(int[] tuple) {
        return this.relation.isConsistent(tuple[0], tuple[1]);
    }

    public BinRelation getRelation() {
        return this.relation;
    }

    @Override
    public Boolean isEntailed() {
        boolean always = true;
        DisposableIntIterator itv1 = this.v0.getDomain().getIterator();
        while (itv1.hasNext()) {
            int nbs = 0;
            int val = itv1.next();
            DisposableIntIterator itv2 = this.v1.getDomain().getIterator();
            while (itv2.hasNext()) {
                if (!this.relation.isConsistent(val, itv2.next())) continue;
                ++nbs;
            }
            if (nbs == 0) {
                always = false;
            } else if (nbs != this.v1.getDomainSize()) {
                return null;
            }
            itv2.dispose();
        }
        itv1.dispose();
        if (always) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }
}

