/*
 * Decompiled with CFR 0.152.
 */
package choco.kernel.solver.constraints.integer;

import choco.kernel.solver.SolverException;
import choco.kernel.solver.constraints.integer.AbstractIntSConstraint;
import choco.kernel.solver.variables.Var;
import choco.kernel.solver.variables.integer.IntDomainVar;

public abstract class AbstractTernIntSConstraint
extends AbstractIntSConstraint {
    protected IntDomainVar v0;
    protected IntDomainVar v1;
    protected IntDomainVar v2;
    protected int cIdx0;
    protected int cIdx1;
    protected int cIdx2;

    public AbstractTernIntSConstraint(IntDomainVar x0, IntDomainVar x1, IntDomainVar x2) {
        super(0);
        this.v0 = x0;
        this.v1 = x1;
        this.v2 = x2;
    }

    @Override
    public void setConstraintIndex(int i, int val) {
        if (i == 0) {
            this.cIdx0 = val;
        } else if (i == 1) {
            this.cIdx1 = val;
        } else if (i == 2) {
            this.cIdx2 = val;
        } else {
            throw new SolverException("bug in setConstraintIndex i:" + i + " this: " + this);
        }
    }

    @Override
    public int getConstraintIdx(int idx) {
        if (idx == 0) {
            return this.cIdx0;
        }
        if (idx == 1) {
            return this.cIdx1;
        }
        if (idx == 2) {
            return this.cIdx2;
        }
        return -1;
    }

    @Override
    public boolean isCompletelyInstantiated() {
        return this.v0.isInstantiated() && this.v1.isInstantiated() && this.v2.isInstantiated();
    }

    @Override
    public int getNbVars() {
        return 3;
    }

    @Override
    public Var getVar(int i) {
        if (i == 0) {
            return this.v0;
        }
        if (i == 1) {
            return this.v1;
        }
        if (i == 2) {
            return this.v2;
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void setVar(int i, Var v) {
        if (!(v instanceof IntDomainVar)) throw new SolverException("BUG in CSP network management: wrong type of Var for setVar");
        if (i == 0) {
            this.v0 = (IntDomainVar)v;
            return;
        } else if (i == 1) {
            this.v1 = (IntDomainVar)v;
            return;
        } else {
            if (i != 2) throw new SolverException("BUG in CSP network management: too large index for setVar");
            this.v2 = (IntDomainVar)v;
        }
    }

    @Override
    public IntDomainVar getIntVar(int i) {
        if (i == 0) {
            return this.v0;
        }
        if (i == 1) {
            return this.v1;
        }
        if (i == 2) {
            return this.v2;
        }
        return null;
    }
}

