/*
 * Decompiled with CFR 0.152.
 */
package choco.kernel.solver.constraints.integer;

import choco.kernel.solver.SolverException;
import choco.kernel.solver.constraints.integer.AbstractIntSConstraint;
import choco.kernel.solver.variables.Var;
import choco.kernel.solver.variables.integer.IntDomainVar;

public abstract class AbstractLargeIntSConstraint
extends AbstractIntSConstraint {
    public IntDomainVar[] vars;
    public int[] cIndices;
    public int cste;

    @Deprecated
    public AbstractLargeIntSConstraint(int n) {
        super(2);
        this.vars = new IntDomainVar[n];
        this.cIndices = new int[n];
    }

    public AbstractLargeIntSConstraint(IntDomainVar[] vars) {
        super(2);
        this.vars = new IntDomainVar[vars.length];
        System.arraycopy(vars, 0, this.vars, 0, vars.length);
        this.cIndices = new int[vars.length];
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        AbstractLargeIntSConstraint newc = (AbstractLargeIntSConstraint)super.clone();
        newc.vars = new IntDomainVar[this.vars.length];
        System.arraycopy(this.vars, 0, newc.vars, 0, this.vars.length);
        this.cIndices = new int[this.cIndices.length];
        System.arraycopy(this.cIndices, 0, newc.cIndices, 0, this.cIndices.length);
        return newc;
    }

    @Override
    public void setConstraintIndex(int i, int val) {
        if (i < 0 || i >= this.vars.length) {
            throw new SolverException("bug in setConstraintIndex i:" + i + " this: " + this);
        }
        this.cIndices[i] = val;
    }

    @Override
    public int getConstraintIdx(int i) {
        if (i >= 0 && i < this.vars.length) {
            return this.cIndices[i];
        }
        return -1;
    }

    @Override
    public boolean isCompletelyInstantiated() {
        int nVariables = this.vars.length;
        for (int i = 0; i < nVariables; ++i) {
            if (this.vars[i].isInstantiated()) continue;
            return false;
        }
        return true;
    }

    @Override
    public int getNbVars() {
        return this.vars.length;
    }

    @Override
    public Var getVar(int i) {
        if (i >= 0 && i < this.vars.length) {
            return this.vars[i];
        }
        return null;
    }

    @Override
    public void setVar(int i, Var v) {
        if (v instanceof IntDomainVar) {
            if (i < 0 || i >= this.vars.length) {
                throw new SolverException("BUG in CSP network management: too large index for setVar");
            }
        } else {
            throw new SolverException("BUG in CSP network management: wrong type of Var for setVar");
        }
        this.vars[i] = (IntDomainVar)v;
    }

    @Override
    public IntDomainVar getIntVar(int i) {
        if (i >= 0 && i < this.getNbVars()) {
            return this.vars[i];
        }
        return null;
    }
}

