/*
 * Decompiled with CFR 0.152.
 */
package choco.kernel.solver.constraints.integer;

import choco.kernel.common.util.IntIterator;
import choco.kernel.solver.ContradictionException;
import choco.kernel.solver.Solver;
import choco.kernel.solver.constraints.AbstractSConstraint;
import choco.kernel.solver.constraints.SConstraintType;
import choco.kernel.solver.constraints.integer.IntSConstraint;
import java.util.logging.Logger;

public abstract class AbstractIntSConstraint
extends AbstractSConstraint
implements IntSConstraint {
    protected static final Logger logger = Logger.getLogger("choco.kernel.solver.propagation.const");

    protected AbstractIntSConstraint(int priority) {
        super(priority);
    }

    @Override
    public void awakeOnInst(int idx) throws ContradictionException {
        this.propagate();
    }

    @Override
    public void awakeOnRemovals(int idx, IntIterator deltaDomain) throws ContradictionException {
        if (deltaDomain != null) {
            while (deltaDomain.hasNext()) {
                int val = deltaDomain.next();
                this.awakeOnRem(idx, val);
            }
        }
    }

    @Override
    public boolean isCompletelyInstantiated() {
        int n = this.getNbVars();
        for (int i = 0; i < n; ++i) {
            if (this.getIntVar(i).isInstantiated()) continue;
            return false;
        }
        return true;
    }

    @Override
    public void awakeOnBounds(int varIndex) throws ContradictionException {
        this.awakeOnInf(varIndex);
        this.awakeOnSup(varIndex);
    }

    @Override
    public boolean isConsistent() {
        return this.isEntailed() == Boolean.TRUE;
    }

    @Deprecated
    public int getSelfIndex() {
        Solver solver = this.getSolver();
        for (int i = 0; i < solver.getNbIntConstraints(); ++i) {
            IntSConstraint c = solver.getIntConstraint(i);
            if (c != this) continue;
            return i;
        }
        return -1;
    }

    @Override
    public boolean isSatisfied() {
        int[] tuple = new int[this.getNbVars()];
        for (int i = 0; i < tuple.length; ++i) {
            assert (this.getIntVar(i).isInstantiated());
            tuple[i] = this.getIntVar(i).getVal();
        }
        return this.isSatisfied(tuple);
    }

    @Override
    public boolean isSatisfied(int[] tuple) {
        throw new UnsupportedOperationException(this + " needs to implement isSatisfied(int[] tuple) to be embedded in reified constraints");
    }

    @Override
    public void awakeOnInf(int varIdx) throws ContradictionException {
        this.constAwake(false);
    }

    @Override
    public void awakeOnSup(int varIdx) throws ContradictionException {
        this.constAwake(false);
    }

    @Override
    public void awakeOnRem(int varIdx, int val) throws ContradictionException {
        this.constAwake(false);
    }

    @Override
    public SConstraintType getConstraintType() {
        return SConstraintType.INTEGER;
    }

    @Override
    public int getFineDegree(int idx) {
        return 1;
    }
}

