/*
 * Decompiled with CFR 0.152.
 */
package choco.kernel.solver.constraints.global.scheduling;

import choco.kernel.model.ModelException;
import choco.kernel.model.variables.integer.IntegerVariable;
import choco.kernel.model.variables.scheduling.TaskVariable;
import choco.kernel.solver.constraints.global.scheduling.IResourceData;

public final class RscData
implements IResourceData {
    private static int resourceIndex = 0;
    private final String name;
    private final int nbReq;
    private final int nbOpt;
    private final int nbTot;
    private final IntegerVariable uppBound;

    public RscData(String name, TaskVariable[] tasks, IntegerVariable[] usages, IntegerVariable uppBound) {
        if (tasks == null || tasks.length == 0) {
            throw new ModelException("Empty resource ?");
        }
        this.nbTot = tasks.length;
        if (usages == null) {
            this.nbOpt = 0;
        } else {
            this.nbOpt = usages.length;
            if (this.nbOpt > this.nbTot) {
                throw new ModelException("Invalid resource dimension.");
            }
            for (int i = 0; i < usages.length; ++i) {
                if (usages[i].isBoolean()) continue;
                throw new ModelException(usages[i].pretty() + " should be a boolean variable.");
            }
        }
        this.nbReq = this.nbTot - this.nbOpt;
        this.name = name == null ? "rsc" + resourceIndex++ : name;
        this.uppBound = uppBound;
    }

    @Override
    public int getNbOptionalTasks() {
        return this.nbOpt;
    }

    @Override
    public int getNbRequiredTasks() {
        return this.nbReq;
    }

    @Override
    public int getNbTasks() {
        return this.nbTot;
    }

    @Override
    public String getRscName() {
        return this.name;
    }

    public final IntegerVariable getUppBound() {
        return this.uppBound;
    }
}

