/*
 * Decompiled with CFR 0.152.
 */
package choco.kernel.solver.constraints.global.matching;

import choco.kernel.memory.IStateIntVector;
import choco.kernel.solver.constraints.global.matching.AbstractBipartiteGraph;
import choco.kernel.solver.variables.integer.IntDomainVar;

public abstract class AbstractBipartiteMatching
extends AbstractBipartiteGraph {
    protected IStateIntVector refInverseMatch;

    public AbstractBipartiteMatching(IntDomainVar[] vars, int nbLeft, int nbRight) {
        super(vars, nbLeft, nbRight);
        this.initAbstractBipartiteMatching();
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        AbstractBipartiteMatching newc = (AbstractBipartiteMatching)super.clone();
        newc.initAbstractBipartiteMatching();
        return newc;
    }

    public void initAbstractBipartiteMatching() {
        this.refInverseMatch = this.getSolver().getEnvironment().makeIntVector(this.nbRightVertices, -1);
    }

    public int inverseMatch(int j) {
        return this.refInverseMatch.get(j);
    }

    @Override
    public void increaseMatchingSize(int j) {
        this.matchingSize.set(this.matchingSize.get() + 1);
    }

    @Override
    public void decreaseMatchingSize(int j) {
        this.matchingSize.set(this.matchingSize.get() - 1);
    }

    @Override
    public void deleteMatch(int i, int j) {
        if (j == this.refMatch.get(i)) {
            this.refMatch.set(i, -1);
            this.refInverseMatch.set(j, -1);
            this.decreaseMatchingSize(j);
        }
    }

    @Override
    public void putRefMatch(int i, int j) {
        this.refMatch.set(i, j);
        this.refInverseMatch.set(j, i);
    }

    @Override
    public void setMatch(int i, int j) {
        int j0 = this.refMatch.get(i);
        int i0 = this.refInverseMatch.get(j);
        if (j0 != j) {
            if (j0 >= 0) {
                this.refInverseMatch.set(j0, -1);
                this.decreaseMatchingSize(j0);
            }
            if (i0 >= 0) {
                this.refMatch.set(i0, -1);
                this.decreaseMatchingSize(j);
            }
            this.refMatch.set(i, j);
            this.refInverseMatch.set(j, i);
            this.increaseMatchingSize(j);
        }
    }

    @Override
    public boolean mayDiminishFlowFromSource(int j) {
        return this.refInverseMatch.get(j) != -1;
    }

    @Override
    public boolean mayGrowFlowFromSource(int j) {
        return this.refInverseMatch.get(j) == -1;
    }

    @Override
    public boolean mustGrowFlowFromSource(int j) {
        return false;
    }
}

