/*
 * Decompiled with CFR 0.152.
 */
package choco.kernel.solver.constraints;

import choco.kernel.memory.IStateBool;
import choco.kernel.memory.IStateInt;
import choco.kernel.solver.ContradictionException;
import choco.kernel.solver.Solver;
import choco.kernel.solver.constraints.SConstraintType;
import choco.kernel.solver.propagation.ConstraintEvent;
import choco.kernel.solver.propagation.EventQueue;
import choco.kernel.solver.propagation.PropagationEvent;
import choco.kernel.solver.propagation.Propagator;
import choco.kernel.solver.variables.Var;
import java.util.HashMap;

public abstract class AbstractSConstraint
implements Propagator {
    public Solver solver;
    protected int priority;
    protected ConstraintEvent constAwakeEvent;
    protected IStateBool active;
    protected SConstraintType constraintType;
    protected IStateInt nbVarNotInst;
    private static int ABSTRACTSCONSTRAINT_EXTENSIONS_NB = 0;
    private static final HashMap<String, Integer> REGISTERED_ABSTRACTSCONSTRAINT_EXTENSIONS = new HashMap();
    public Object[] extensions = new Object[4];

    public static int getAbstractSConstraintExtensionNumber(String name) {
        Integer index = REGISTERED_ABSTRACTSCONSTRAINT_EXTENSIONS.get(name);
        if (index == null) {
            index = ABSTRACTSCONSTRAINT_EXTENSIONS_NB++;
            REGISTERED_ABSTRACTSCONSTRAINT_EXTENSIONS.put(name, index);
        }
        return index;
    }

    public AbstractSConstraint() {
        this(0);
    }

    public AbstractSConstraint(int priority) {
        this.priority = priority;
        this.constAwakeEvent = new ConstraintEvent(this, false, priority);
    }

    public void setExtension(int extensionNumber, Object extension) {
        if (extensionNumber >= this.extensions.length) {
            Object[] newArray = new Object[this.extensions.length * 2];
            System.arraycopy(this.extensions, 0, newArray, 0, this.extensions.length);
            this.extensions = newArray;
        }
        this.extensions[extensionNumber] = extension;
    }

    public Object getExtension(int extensionNumber) {
        return this.extensions[extensionNumber];
    }

    @Override
    public PropagationEvent getEvent() {
        return this.constAwakeEvent;
    }

    @Override
    public void constAwake(boolean isInitialPropagation) {
        this.solver.getPropagationEngine().postConstAwake(this, isInitialPropagation);
    }

    @Override
    public int getPriority() {
        return this.priority;
    }

    @Override
    public void awake() throws ContradictionException {
        this.propagate();
    }

    @Override
    public Solver getSolver() {
        if (this.solver != null) {
            return this.solver;
        }
        int nVars = this.getNbVars();
        for (int i = 0; i < nVars; ++i) {
            Var v = this.getVar(i);
            if (v.getSolver() == null) continue;
            return v.getSolver();
        }
        return null;
    }

    @Override
    public void setActive() {
        if (!this.isActive()) {
            this.active.set(true);
            this.constAwake(true);
        }
    }

    @Override
    public void setActiveSilently() {
        this.active.set(true);
    }

    @Override
    public void setPassive() {
        if (this.active != null) {
            this.active.set(false);
            ConstraintEvent evt = this.constAwakeEvent;
            EventQueue q = this.solver.getPropagationEngine().getQueue(evt);
            q.remove(evt);
        }
    }

    public void setEntailed() {
        this.setPassive();
    }

    @Override
    public void delete() {
        this.solver.eraseConstraint(this);
    }

    public void fail() throws ContradictionException {
        this.solver.getPropagationEngine().raiseContradiction(this, 2);
    }

    @Override
    public Boolean isEntailed() {
        if (this.isCompletelyInstantiated()) {
            return this.isSatisfied();
        }
        return null;
    }

    @Override
    public boolean isActive() {
        if (this.active != null) {
            return this.active.get();
        }
        return false;
    }

    @Override
    public void addListener(boolean dynamicAddition) {
        int n = this.getNbVars();
        for (int i = 0; i < n; ++i) {
            this.setConstraintIndex(i, this.getVar(i).addConstraint(this, i, dynamicAddition));
            this.getVar(i).getEvent().addPropagatedEvents(this.getFilteredEventMask(i));
        }
        this.active = this.solver.getEnvironment().makeBool(false);
    }

    @Override
    public int getFilteredEventMask(int idx) {
        return 65535;
    }

    @Override
    public int getVarIdxInOpposite(int i) {
        return i;
    }

    @Override
    public AbstractSConstraint opposite() {
        throw new UnsupportedOperationException();
    }

    public int connectVar(Var v, int j, boolean dynamicAddition) {
        int cidx = v.addConstraint(this, j, dynamicAddition);
        this.setConstraintIndex(j, cidx);
        return cidx;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public int substituteVar(Var oldvar, Var newvar) {
        int nbSub = 0;
        int nbVars = this.getNbVars();
        for (int i = 0; i < nbVars; ++i) {
            if (this.getVar(i) != oldvar) continue;
            this.setVar(i, newvar);
            ++nbSub;
        }
        return nbSub;
    }

    public int getNbVarNotInst() {
        return this.nbVarNotInst.get();
    }

    public final void decNbVarNotInst() {
        if (this.nbVarNotInst != null) {
            this.nbVarNotInst.add(-1);
        }
    }

    @Override
    public void setSolver(Solver solver) {
        this.solver = solver;
        this.nbVarNotInst = this.solver.getEnvironment().makeInt(this.getNbVars());
    }

    public abstract SConstraintType getConstraintType();

    @Override
    public String pretty() {
        return this.toString();
    }
}

